package com.bizvane.fitmentservice.interfaces;

import com.bizvane.fitmentservice.models.vo.AppletVipPrivilegeConfigSaveVO;
import com.bizvane.fitmentservice.models.vo.AppletVipPrivilegeConfigVO;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;

import java.util.List;

/**
 * @author smzdm
 */
public interface AppleVipPrivilegeConfigService {

    /**
     * 会员特权配置列表
     * @param sysAccountPo
     * @return
     */
    ResponseData<List<AppletVipPrivilegeConfigVO>> getList(SysAccountPO sysAccountPo);

    /**
     * 会员特权配置保存
     *
     * @param appletVipPrivilegeConfigSaveVO
     * @param sysAccountPo
     * @return
     */
    ResponseData<String> save(AppletVipPrivilegeConfigSaveVO appletVipPrivilegeConfigSaveVO, SysAccountPO sysAccountPo);

    /**
     * 会员特权配置查询是否存在被使用
     * @param privilegeConfigId
     * @param sysAccountPo
     * @return
     */
    ResponseData<Boolean> countUsedByConfigId(Long privilegeConfigId, SysAccountPO sysAccountPo);
}
