package com.bizvane.fitmentservice.models.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author smzdm
 */
@Data
public class AppletVipCardPrivilegeVO implements Serializable {

    private static final long serialVersionUID = 3362876591738372723L;

    @ApiModelProperty(value = "会员卡关联特权表主键",name = "appletVipCardPrivilegeId")
    private Long appletVipCardPrivilegeId;

    @ApiModelProperty(value = "企业id",name = "sysCompanyId")
    private Long sysCompanyId;

    @ApiModelProperty(value = "品牌id",name = "sysBrandId")
    private Long sysBrandId;

    @ApiModelProperty(value = "等级id",name = "gradeId")
    private Long gradeId;

    @ApiModelProperty(value = "等级特权说明",name = "privilegeExplain")
    private String privilegeExplain;

    @ApiModelProperty(value = "是否享受特权,对应图标不置灰 0享受(不置灰) 1不享受(置灰)",name = "iconGrey")
    private Boolean iconGrey;

    @ApiModelProperty(value = "小程序会员卡特权表id",name = "privilegeConfigId")
    private Long privilegeConfigId;

    @ApiModelProperty(value = "特权名称",name = "privilegeName")
    private String privilegeName;

    @ApiModelProperty(value = "特权logo",name = "privilegeLogo")
    private String privilegeLogo;

    @ApiModelProperty(value = "排序",name = "sort")
    private Integer sort;

    @ApiModelProperty(value = "数据有效性：1=有效；0=无效",name = "valid")
    private Boolean valid;
}
