package com.bizvane.fitmentservice.models.vo.graphic.info;

import com.bizvane.fitmentservice.models.enums.GraphicSourceTypeEnums;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Date;

@Data
public class AppletGraphicAddReq {

    @ApiModelProperty(value = "来源类型 1本地图文 2线上图文")
    @NotNull(message = "来源类型不能为空")
    private Integer sourceType;

    @ApiModelProperty(value = "文章头图")
    @NotBlank(message = "文章头图不能为空")
    private String graphicTopImgs;

    @ApiModelProperty(value = "文章标题")
    @NotBlank(message = "文章标题不能为空")
    private String graphicTopic;

    @ApiModelProperty(value = "链接")
    private String graphicUrl;

    @ApiModelProperty(value = "日期")
    private Date graphicDate;

    @ApiModelProperty(value = "文章内容")
    private String graphicContent;

    @ApiModelProperty(value = "初始阅读总数 默认 0")
    private Integer initReadCount;

    @ApiModelProperty(value = "排序字段 0最前,数字越大越在后")
    private Integer sort;

    @ApiModelProperty(value = "图文活动 id")
    @NotNull(message = "图文活动 id不能为空")
    private Long graphicActivityId;

    @AssertTrue(message = "来源类型不正确")
    private boolean isGraphicSource(){
        return GraphicSourceTypeEnums.getByCode(sourceType) != null;
    }

    @AssertTrue(message = "本地图文,文章内容不能为空")
    private boolean isLocalGraphic(){
        GraphicSourceTypeEnums typeEnums = GraphicSourceTypeEnums.getByCode(sourceType);
        if(typeEnums ==  GraphicSourceTypeEnums.LOCAL_GRAPHIC){
            return StringUtils.isNotBlank(graphicContent);
        }
        return true;
    }

    @AssertTrue(message = "线上图文,链接，日期不能为空")
    private boolean isOnlineGraphic(){
        GraphicSourceTypeEnums typeEnums = GraphicSourceTypeEnums.getByCode(sourceType);
        if(typeEnums ==  GraphicSourceTypeEnums.ONLINE_GRAPHIC){
            return StringUtils.isNotBlank(graphicUrl) && graphicDate != null;
        }
        return true;
    }

}
