package com.bizvane.fitmentservice.interfaces;

import com.bizvane.fitmentservice.models.vo.graphic.activity.*;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;

import java.util.List;

public interface AppletGraphicActivityService {

    /**
     * 查询图文活动列表，不分页
     *
     * @param req
     * @return
     */
    ResponseData<List<AppletGraphicActivityRsp>> listAll(AppletGraphicActivityReq req);

    /**
     * 查询图文活动列表分页
     *
     * @param req
     * @return
     */
    ResponseData<PageInfo<AppletGraphicActivityRsp>> page(AppletGraphicActivityReq req);

    /**
     * 新增图文活动
     *
     * @param req
     * @return
     */
    ResponseData<AppletGraphicActivityAddRsp> insert(AppletGraphicActivityAddReq req, SysAccountPO sysAccountPo);

    /**
     * 修改图文活动
     *
     * @param req
     * @return
     */
    ResponseData<AppletGraphicActivityUpdateRsp> update(AppletGraphicActivityUpdateReq req, SysAccountPO sysAccountPo);

    /**
     * 删除图文活动
     *
     * @param req
     * @return
     */
    ResponseData<AppletGraphicActivityDeleteRsp> delete(AppletGraphicActivityDeleteReq req, SysAccountPO sysAccountPo);
}
