package com.bizvane.customized.facade.utils;


import com.bizvane.customized.facade.enums.goldLionEnums.DescEnum;

import java.util.Objects;

/**
 * @author shaopeng.hu
 */
public class DescEnumUtils {

    private DescEnumUtils() {
    }

    public static <K, E extends Enum<E> & DescEnum<K>> String getDesc(Class<E> descEnumClass, K code) {
        if (null == code) {
            return null;
        }
        for (DescEnum enumConstant : descEnumClass.getEnumConstants()) {
            if (Objects.equals(enumConstant.getCode(), code)) {
                return enumConstant.getDesc();
            }
        }
        return null;
    }

    public static <K, E extends Enum<E> & DescEnum<K>> E getEnum(Class<E> descEnumClass, K code) {
        if (null == code) {
            return null;
        }
        for (DescEnum enumConstant : descEnumClass.getEnumConstants()) {
            if (Objects.equals(enumConstant.getCode(), code)) {
                return (E) enumConstant;
            }
        }
        return null;
    }
}
