package com.bizvane.customized.facade.enums;

/**
 * 储值卡变更操作类型
 * @author Bizvane
 */
public enum StorageOpsTypeEnum {

    /**
     *  储值卡变更操作类型
     */
    ADD(1, "新增"),

    EDIT(2, "编辑"),

    SEND(3, "转赠"),

    RECEIVE(4, "受赠"),

    POS_CONSUME(5, "消费"),

    BACK(6, "退回");


    private final int code;
    private final String msg;

    StorageOpsTypeEnum(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public int getCode() {
        return code;
    }

    public String getMsg() {
        return msg;
    }

    /**
     * 获取类型
     * @return 对应名称
     */
    public static String getTypeName(int code) {
        for (StorageOpsTypeEnum st : StorageOpsTypeEnum.values()) {
            if (st.code == code) {
                return st.getMsg();
            }
        }
        return "";
    }
}
