package com.bizvane.customized.facade.enums;

/**
 * 会员卡使用状态
 */
public enum CrmCardUseStatusEnum {

    FROZEN(4,"手工冻结");

    private Integer code;
    private String msg;

    CrmCardUseStatusEnum(Integer code, String msg){
        this.code = code;
        this.msg = msg;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }


    public static CrmCardUseStatusEnum getMsg(Integer code) {
        if (code == null) {
            return null;
        }
        for (CrmCardUseStatusEnum type : CrmCardUseStatusEnum.values()) {
            if (code.equals(type.getCode())) {
                return type;
            }
        }
        return null;
    }

    public static CrmCardUseStatusEnum getMsg(String msg) {
        if (msg == null) {
            return null;
        }
        for (CrmCardUseStatusEnum type : CrmCardUseStatusEnum.values()) {
            if (msg.equals(type.getMsg())) {
                return type;
            }
        }
        return null;
    }
}
