/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.facade.utils;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.SSLContext;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class OkHttpUtils {
    private static final Logger log = LoggerFactory.getLogger(OkHttpUtils.class);

    public String getRequest(String url) throws IOException {
        log.info("\u8bf7\u6c42\u4fe1\u606furl---->{}", (Object)url);
        OkHttpClient client = new OkHttpClient().newBuilder().build();
        Request request = new Request.Builder().url(url).method("GET", null).addHeader("Cookie", "PHPSESSID=d2a5a9a779916e0053ff3520c6763759").build();
        Response response = client.newCall(request).execute();
        String result = null;
        if (response != null) {
            if (response.body() != null) {
                result = new String(response.body().bytes());
                response.body().close();
            }
            response.close();
        }
        log.info("result---->{}", result);
        return result;
    }

    public JSONObject httpGet(String url, Map<String, String> params, boolean flag) {
        OkHttpClient okHttpClient = new OkHttpClient();
        StringBuilder paramsStr = new StringBuilder();
        if (!CollectionUtils.isEmpty(params)) {
            params.keySet().forEach(res -> {
                if (StringUtils.isNotBlank((CharSequence)paramsStr) || flag) {
                    paramsStr.append("&");
                } else {
                    paramsStr.append("?");
                }
                try {
                    paramsStr.append(String.format("%s=%s", res, URLEncoder.encode((String)params.get(res), "UTF-8")));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    log.info("httpGet method(),unsupportedEncodingException:{}", (Object)ExceptionUtils.getStackTrace((Throwable)unsupportedEncodingException));
                }
            });
        }
        String requestUrl = url + paramsStr;
        log.info("httpGet method(),requestUrl:{}", (Object)requestUrl);
        Request request = new Request.Builder().url(requestUrl).get().addHeader("accept", "application/json; charset=utf-8").build();
        try {
            Response response = okHttpClient.newCall(request).execute();
            String resultStr = response.body().string();
            response.close();
            log.info("httpGet jsonObjectResult:{}", (Object)resultStr);
            JSONObject jsonObjectResult = JSONObject.parseObject((String)resultStr);
            log.info("httpGet jsonObjectResult:{}", (Object)jsonObjectResult.toJSONString());
            return jsonObjectResult;
        }
        catch (Exception exception) {
            log.info("httpGet method(),exception:{}", (Object)ExceptionUtils.getStackTrace((Throwable)exception));
            return null;
        }
    }

    public static String httpPost(String url, String body, String sign, String sn) {
        String xmlRes = "{}";
        CloseableHttpClient client = OkHttpUtils.createSSLClientDefault();
        HttpPost httpPost = new HttpPost(url);
        try {
            log.debug("Request string: " + body);
            StringEntity entity = new StringEntity(body, "UTF-8");
            entity.setContentType("application/json");
            httpPost.setEntity((HttpEntity)entity);
            httpPost.addHeader("Content-Type", "application/json");
            httpPost.addHeader("Authorization", sn + " " + sign);
            HttpResponse response = client.execute((HttpUriRequest)httpPost);
            xmlRes = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            log.debug("Response string: " + xmlRes);
        }
        catch (ClientProtocolException e) {
            log.error("", (Throwable)e);
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
        }
        return xmlRes;
    }

    private static CloseableHttpClient createSSLClientDefault() {
        try {
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            }).build();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext);
            return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
        }
        catch (KeyManagementException e) {
            log.error("", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            log.error("", (Throwable)e);
        }
        catch (KeyStoreException e) {
            log.error("", (Throwable)e);
        }
        return HttpClients.createDefault();
    }
}

