package com.bizvane.customized.facade.models.vo.ur;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * mobileTel
 * cardCode
 * storedCardNo
 * 储值卡号
 * 会员等级
 * 交易时间
 * 业务类型
 * 流水状态
 * 储值卡充值单号
 * 微信充值流水单号
 * 变动总金额
 * 本金变动金额
 * 赠送变动金额
 * 消费订单号
 * 消费门店
 * 储值卡总余额
 * 储值卡本金余额
 * 储值卡赠送余额
 */
@Data
public class ChargeAddRecordListRspVo implements Serializable {
    @ApiModelProperty(value = "储值卡号")
    private String cardNo;
    @ApiModelProperty(value = "会员卡号")
    private String cardCode;
    @ApiModelProperty(value = "手机号")
    private String mobileTel;
    @ApiModelProperty(value = "会员等级")
    private String levelCode;
    private String levelName;
    @ApiModelProperty(value = "交易时间")
    private Date createDate;
    @ApiModelProperty(value = "类型：'1:订单退货 2:充值 3:退卡（退款） 4:消费订单 5 转增 6 受赠 7 转增过期 8 转增撤回 9 新退款 10 平帐'")
    private Integer type;
    @ApiModelProperty(value = "充值状态: 0 未到账  1 已到账 转增状态: 2 待领取 3 已领取 4 已过期 5 已撤回")
    private Integer status;
    @ApiModelProperty(value = "wx支付单号", notes = "wx充值流水单号:merchant_no")
    private String wxPayOrderNo;
    @ApiModelProperty(value = "交易流水号", notes = "储值卡充值单号:record_no")
    private String tradeSerialNumber;
    @ApiModelProperty(value = "变动总金额")
    private BigDecimal totalAmount;
    @ApiModelProperty(value = "本金变动金额")
    private BigDecimal amount;
    @ApiModelProperty(value = "赠送变动金额")
    private BigDecimal giveAmount;
    @ApiModelProperty(value = "储值卡总余额")
    private BigDecimal balanceTotal;
    @ApiModelProperty(value = "储值卡充值总余额")
    private BigDecimal rechargeBalanceTotal;
    @ApiModelProperty(value = "储值卡赠送总余额")
    private BigDecimal giveBalanceTotal;
    @ApiModelProperty(value = "消费订单号")
    private String orderNo;
    //    private String originalOrderNo;
    @ApiModelProperty(value = "消费门店")
    private String storeId;
    @ApiModelProperty(value = "消费门店名称")
    private String storeName;
}
