package com.bizvane.customized.facade.models.vo.mj;

import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Getter
@Setter
public class CurMjGiftCardRecordRequestVo {
    //企业id
    @NotNull(message = "企业id不能为空")
    private Long sysCompanyId;
    //品牌id
    @NotNull(message = "品牌id不能为空")
    private Long sysBrandId;
    //会员凑得
    private String memberCode;
    //会员名称
    private String memberName;
    //卡号
    private String cardNo;
    //erpId
    private String erpId;
    //手机号
    private String phone;
    //金额
    @NotNull(message = "变更金额不能为空")
    private BigDecimal money;
    //流水号
    @NotNull(message = "流水号不能为空")
    private String serialNumber;
    //更改类型
    @NotNull(message = "更改类型不能为空")
    private Byte alterationType;
    //消费门店id(线上)
    private Long consumeStoreId;
    //消费门店code(线上)
    private String consumeStoreCode;
    //消费门店名称(线上)
    private String consumeStoreName;

    //线下消费门店code;
    //@NotNull(message = "更改类型不能为空")
    private String offlineConsumeStoreCode;

    //变更时间
    private Date alterationDate;
    //礼品卡号
    private String giftCardNo;


    //开始时间
    private Date startDate;
    //结束时间
    private Date endDate;
    //起始页
    private Integer pageNum;
    //分页大小
    private Integer pageSize;

    /**
     * 会员卡号/手机号/名称搜索
     */
    private String memberNameOrCodeOrPhoneSearch;

    //会员code集合
    private List<String> memberCodeList;

    //是否有效
    private Boolean valid;
    //创建时间
    private Date createDate;
}
