package com.bizvane.customized.facade.models.po;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

@ApiModel(value="com.bizvane.customized.facade.models.po.CusMbrFrozenDefPo")
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class CusMbrFrozenDefPo implements Serializable {
    /**
    * 主键id
    */
    @ApiModelProperty(value="主键id")
    private Long cusMbrFrozenDefId;

    /**
    * 所属企业id
    */
    @ApiModelProperty(value="所属企业id")
    private Long sysCompanyId;

    /**
    * 品牌id
    */
    @ApiModelProperty(value="品牌id")
    private Long sysBrandId;

    /**
    * 定义规则json,unit 1:周 2:月，xxxKey:为值，xxxEnable:是否启用 0禁用,1启用
    */
    @ApiModelProperty(value="定义规则json,unit 1:周 2:月，xxxKey:为值，xxxEnable:是否启用")
    private String rulesJson;

    /**
    * 数据有效性：1=有效；0=无效
    */
    @ApiModelProperty(value="数据有效性：1=有效；0=无效")
    private Boolean valid;

    /**
    * 备注
    */
    @ApiModelProperty(value="备注")
    private String remark;

    /**
    * 创建人id
    */
    @ApiModelProperty(value="创建人id")
    private Long createUserId;

    /**
    * 创建人
    */
    @ApiModelProperty(value="创建人")
    private String createUserName;

    /**
    * 创建日期
    */
    @ApiModelProperty(value="创建日期")
    private Date createDate;

    /**
    * 修改人id
    */
    @ApiModelProperty(value="修改人id")
    private Long modifiedUserId;

    /**
    * 修改人
    */
    @ApiModelProperty(value="修改人")
    private String modifiedUserName;

    /**
    * 修改时间
    */
    @ApiModelProperty(value="修改时间")
    private Date modifiedDate;

    /**
    * 版本号
    */
    @ApiModelProperty(value="版本号")
    private Integer version;

    private static final long serialVersionUID = 1L;
}