package com.bizvane.customized.facade.interfaces;

import com.bizvane.customized.facade.models.vo.ChangePasswordRequestVo;
import com.bizvane.customized.facade.models.vo.MiniQueryStorageRequestVo;
import com.bizvane.customized.facade.models.vo.MiniQueryStorageResponseVo;
import com.bizvane.customized.facade.models.vo.QueryRecordListRequestVo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;

@FeignClient(value="${feign.client.customized.name}",path="${feign.client.customized.path}/miniStorageCard")
@Api(value = "储值卡相关接口",tags = {"储值卡"})
public interface MiniStorageCardServiceFeign {

    @ApiOperation(value = "根据memberCode查询储值卡上信息", notes = "第一次调用查询接口时，生成卡号条形码和密码条形码", produces = "application/json", position = 0)
    @PostMapping("/queryMiniStorage")
    ResponseData<MiniQueryStorageResponseVo> queryMiniStorage(@RequestBody @Valid MiniQueryStorageRequestVo miniQueryStorageRequestVo);

    @ApiOperation(value = "修改密码", notes = "", produces = "application/json", position = 0)
    @PostMapping("/changePassword")
    ResponseData changePassword(@RequestBody @Valid ChangePasswordRequestVo changePasswordRequestVo);

    @ApiOperation(value = "查询储值卡记录列表", notes = "第一次调用查询接口时，生成卡号条形码和密码条形码", produces = "application/json", position = 0)
    @PostMapping("/queryRecordList")
    ResponseData queryRecordList(@RequestBody @Valid QueryRecordListRequestVo queryRecordListRequestVo);

}
