package com.bizvane.customized.facade.enums.teddy;

import lombok.AllArgsConstructor;
import lombok.Getter;

@AllArgsConstructor
@Getter
public enum CusTeddyGoodsVerifyStatusEnum {

    VERIFY_NOT(0, "未核销"),
    VERIFY_YET(1, "已核销"),
    ;

    private Integer code;
    private String msg;

    public static String getMsg(Integer code){
        for (CusTeddyGoodsVerifyStatusEnum c: CusTeddyGoodsVerifyStatusEnum.values()){
            if(c.getCode().equals(code)){
                return c.getMsg();
            }
        }
        return null;
    }

}
