package com.bizvane.customized.facade.interfaces;

import com.bizvane.customized.facade.models.po.CusDistributionExchangePO;
import com.bizvane.customized.facade.models.po.CusDistributionRecordPO;
import com.bizvane.customized.facade.models.vo.*;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.validation.Valid;

/**
 * @author  lixiao
 * @date  2019-8-8
 */
@FeignClient(value="${feign.client.customized.name}",path="${feign.client.customized.path}/memberDistributionRpc")
@Api(value = "分销RPC接口",tags = {"分销RPC接口"})
public interface MemberDistributionRpcServiceFeign {

    @PostMapping(value = "/queryDistribution")
    ResponseData<MemberDistributionPageVo> queryDistribution(@RequestBody @Valid MemberDistributionPageVo vo);

    @PostMapping(value = "/querycommissionRegular")
    ResponseData<String> queryCommissionRegular(@RequestBody @Valid MemberDistributionPageVo vo);

    @PostMapping(value = "/queryCommissionExchange")
    ResponseData<PageInfo<CusDistributionExchangePO>> queryCommissionExchange(@RequestBody @Valid MemberDistributionVo vo);

    @PostMapping(value = "/getCommissionRecord")
    ResponseData<PageInfo<CusDistributionRecordPO>> getCommissionRecord(@RequestBody MemberDistributionVo vo);

    @PostMapping(value = "/queryExchangeRate")
    ResponseData<MemberDistributionPageVo> queryExchangeRate(@RequestBody @Valid MemberDistributionPageVo vo);

    @PostMapping(value = "/getChooseFriends")
    ResponseData<MemberDistributionShareVo> getChooseFriends(@RequestBody @Valid MemberDistributionShareVo vo);

    @PostMapping(value = "/getSharePosters")
    ResponseData<MemberDistributionShareVo> getSharePosters(@RequestBody @Valid MemberDistributionShareVo vo);

    @PostMapping(value = "/commissionExchangeIntegral")
    ResponseData commissionExchangeIntegral(@RequestBody MemberDistributionPageVo vo);

    @PostMapping(value = "/queryMyMember")
    ResponseData queryMyMember(@RequestBody DistributionVo vo);

    @PostMapping(value = "/queryCommissionIntegral")
    ResponseData<MemberDistributionPageVo> queryCommissionIntegral(@RequestBody MemberDistributionPageVo vo);
}
