package com.bizvane.customized.facade.models.vo.ur;


import lombok.Data;
import org.hibernate.validator.constraints.NotEmpty;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

@Data
public class PaidMemberRefundRequestToURVo {
    // 品牌id
    @NotNull
    private Long brandId;
    // 手机号
    @NotNull
    private Long mobileTel;
    // 卡号
    @NotNull
    private String cardCode;
    // 卡级别
    @NotNull
    private String cardLevelCode;
    // 卡级别名称
    @NotNull
    private String cardLevelName;
    // 退款金额
    @NotNull
    private BigDecimal refundAmount;
    // 每日成本
    @NotNull
    private BigDecimal dailyCost;
    // 剩余有效天数
    @NotNull
    private Integer validDays;
    // 已用权益的优惠券金额
    @NotNull
    private BigDecimal usedAmount;
    // 已用权益的优惠券code 用","分割
    private String usedCouponCode;
    // 退款申请时间
    @NotNull
    private Long applyTime;
    }