package com.bizvane.customized.facade.enums.teddy;

import lombok.AllArgsConstructor;
import lombok.Getter;

@AllArgsConstructor
@Getter
public enum CusTeddyGoodsTaskStatusEnum {

    PROCEED(0, "进行中"),
    FINISH(1, "完成"),
    FAIL(2, "失败"),
    ;

    private Integer code;
    private String msg;

    public static String getMsg(Integer code){
        for (CusTeddyGoodsTaskStatusEnum c: CusTeddyGoodsTaskStatusEnum.values()){
            if(c.getCode().equals(code)){
                return c.getMsg();
            }
        }
        return null;
    }

}
