package com.bizvane.customized.facade.enums.mj;

public enum GiftCardAlterationTypeEnum {

    RECHARGE((byte)1, "充值"),
    CONSUMPTION((byte)2, "消费");

    private Byte code;
    private String message;

    GiftCardAlterationTypeEnum(Byte code, String message) {
        this.code = code;
        this.message = message;
    }

    public Byte getCode() {
        return code;
    }

    public void setCode(Byte code) {
        this.code = code;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public static GiftCardAlterationTypeEnum getGiftCardAlterationTypeEnum(Byte code){
        for (GiftCardAlterationTypeEnum value : GiftCardAlterationTypeEnum.values()) {
            if(value.getCode().equals(code)){
                return value;
            }
        }
        return null;
    }
}
