package com.bizvane.customized.facade.interfaces;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;


@FeignClient(value = "${feign.client.customized.name}", path = "${feign.client.customized.path}/memberCase")
@Api(tags = {"哥弟病人病例接口"})
public interface CusMembersCaseServiceFeign {

    /**
     *  病人病例列表接口
     * @param memberCode
     * @param brandId
     * @return
     */
    @GetMapping("/queryCaseList")
    ResponseData<JSONArray> queryCaseList(@RequestParam String memberCode, @RequestParam Long brandId) ;

    /**
     * 病人病例详情接口
     * @param id
     * @param phone
     * @param userCardNo
     * @return
     */
    @GetMapping("/queryCaseDetail")
    ResponseData<JSONObject> queryCaseDetail(@RequestParam(required = false) String id, @RequestParam(required = false) String phone,
                                             @RequestParam(required = false) String userCardNo, @RequestParam Long brandId) ;
}
