package com.bizvane.customized.facade.utils;

import jodd.util.Base64;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.exception.ExceptionUtils;

import java.security.*;
import java.security.spec.X509EncodedKeySpec;

/**
 * @author yuantq
 * @date 2022/1/15
 */
@Slf4j
public class SqbSignatureUtil {

    private static final String SIGNATURE_ALGORITHM = "SHA256WithRSA";

    private static final String KEY_ALGORITHM = "RSA";

    /**
     * 收钱吧验签
     * @param data 签名原数据
     * @param sign 签名
     * @param publicKey 收钱吧公钥
     * @return
     */
    public static boolean validateSign(String data, String sign,String publicKey){
        try {
            Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
            PublicKey localPublicKey = getPublicKeyFromX509(KEY_ALGORITHM, publicKey);
            signature.initVerify(localPublicKey);
            signature.update(data.getBytes());
            byte[] bytesSign = Base64.decode(sign);
            return signature.verify(bytesSign);
        } catch (Exception e) {
            log.error("validateSign error",ExceptionUtils.getStackTrace(e));
            return false;
        }
    }

    public static PublicKey getPublicKeyFromX509(String algorithm, String publicKey) throws Exception{
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        return keyFactory.generatePublic(new X509EncodedKeySpec(Base64.decode(publicKey)));
    }

}
