package com.bizvane.customized.facade.models.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @Author: LiJC
 * @CreateTime: 2019/8/07.
 */
@Data
public class MemberDistributionVo {

    @ApiModelProperty(name = "sysCompanyId", value = "企业id")
    private Long sysCompanyId;

    @ApiModelProperty(name = "brandId",value = "品牌id")
    private Long brandId;

    @io.swagger.annotations.ApiModelProperty(value = "当前页数", name = "pageNumber")
    private Integer pageNumber = 1;

    @io.swagger.annotations.ApiModelProperty(value = "显示条数", name = "pageSize")
    private Integer pageSize = 10;

    @ApiModelProperty(name = "memberCode", value = "分销员Code")
    private String memberCode;

    @ApiModelProperty(name = "name",value = "分销员姓名")
    private String name;

    @ApiModelProperty(name = "phone", value = "分销员手机号")
    private String phone;

    @ApiModelProperty(name = "cName", value = "下线会员姓名")
    private String cName;

    @ApiModelProperty(name = "cPhone", value = "下线会员手机号")
    private String cPhone;

    @ApiModelProperty(name = "orderNo", value = "订单号")
    private String orderNo;

    @ApiModelProperty(name = "startTime", value="开始时间")
    private String startTime;

    @ApiModelProperty(name = "endTime", value="结束时间")
    private String endTime;

    @ApiModelProperty(name = "consumeStartTime", value="消费开始时间")
    private String consumeStartTime;

    @ApiModelProperty(name = "consumeEndTime", value="消费结束时间")
    private String consumeEndTime;

    @ApiModelProperty(name = "dealStartTime", value="结算开始时间")
    private String dealStartTime;

    @ApiModelProperty(name = "dealEndTime", value="结算结束时间")
    private String dealEndTime;

    @ApiModelProperty(name = "commissionStatus", value = "结算状态")
    private Integer commissionStatus;

    @ApiModelProperty(name = "serviceStoreIds", value="店铺id")
    private List<Long> serviceStoreIds;
}
