package com.bizvane.customized.facade.models.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

@Data
public class DistributionVo {
    @ApiModelProperty(name = "operateStartTime", value="操作开始时间")
    private String operateStartTime;

    @ApiModelProperty(name = "memberCode", value = "分销员Code")
    private String memberCode;

    @ApiModelProperty(name = "operateEndTime", value="操作结束时间")
    private String operateEndTime;

    @ApiModelProperty(name = "bindStartTime", value="绑定开始时间")
    private String bindStartTime;

    @ApiModelProperty(name = "bindEndTime", value="绑定结束时间")
    private String bindEndTime;

    @ApiModelProperty(name = "condition", value="分销员列表")
    private String condition;

    @ApiModelProperty(name = "commissionStatus", value = "分销状态")
    private Integer commissionStatus;

    @ApiModelProperty(name = "serviceStoreIds", value="店铺id")
    private List<Long> serviceStoreIds;

    @ApiModelProperty(name = "startTime", value="开始时间")
    private String startTime;

    @ApiModelProperty(name = "endTime", value="结束时间")
    private String endTime;

    @ApiModelProperty(name = "sysCompanyId", value = "企业id")
    private Long sysCompanyId;

    @ApiModelProperty(name = "brandId",value = "品牌id")
    private Long brandId;

    @io.swagger.annotations.ApiModelProperty(value = "当前页数", name = "pageNumber")
    private Integer pageNumber = 1;

    @io.swagger.annotations.ApiModelProperty(value = "显示条数", name = "pageSize")
    private Integer pageSize = 10;

    @ApiModelProperty(name = "name",value = "分销员姓名")
    private String name;

    @ApiModelProperty(name = "phone", value = "分销员手机号")
    private String phone;

    @ApiModelProperty(name = "cName", value = "下线会员姓名")
    private String cName;

    @ApiModelProperty(name = "cPhone", value = "下线会员手机号")
    private String cPhone;

    @ApiModelProperty(name = "orderType", value = "排序类型")
    private String orderType;

    @ApiModelProperty(name = "isDesc", value = "是否倒序")
    private Boolean isDesc;
}
