package com.bizvane.customized.facade.interfaces;

import com.bizvane.customized.facade.models.po.CusDistributionExchangePO;
import com.bizvane.customized.facade.models.po.CusDistributionRecordPO;
import com.bizvane.customized.facade.models.vo.*;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.validation.Valid;

/**
 * @author  lixiao
 * @date  2019-8-8
 */
@FeignClient(value="${feign.client.customized.name}",path="${feign.client.customized.path}/memberDistributionRpc")
@Api(value = "分销RPC接口",tags = {"分销RPC接口"})
public interface MemberDistributionRpcServiceFeign {

    @RequestMapping(value = "/queryDistribution", method = RequestMethod.POST)
    ResponseData<MemberDistributionPageVo> queryDistribution(@RequestBody @Valid MemberDistributionPageVo vo);

    @RequestMapping(value = "/querycommissionRegular", method = RequestMethod.POST)
    ResponseData<String> queryCommissionRegular(@RequestBody @Valid MemberDistributionPageVo vo);

    @RequestMapping(value = "/queryCommissionExchange", method = RequestMethod.POST)
    ResponseData<PageInfo<CusDistributionExchangePO>> queryCommissionExchange(@RequestBody @Valid MemberDistributionVo vo);

    @RequestMapping(value = "/getCommissionRecord", method = RequestMethod.POST)
    ResponseData<PageInfo<CusDistributionRecordPO>> getCommissionRecord(@RequestBody MemberDistributionVo vo);

    @RequestMapping(value = "/queryExchangeRate", method = RequestMethod.POST)
    ResponseData<MemberDistributionPageVo> queryExchangeRate(@RequestBody @Valid MemberDistributionPageVo vo);

    @RequestMapping(value = "/getChooseFriends", method = RequestMethod.POST)
    ResponseData<MemberDistributionShareVo> getChooseFriends(@RequestBody @Valid MemberDistributionShareVo vo);

    @RequestMapping(value = "/getSharePosters", method = RequestMethod.POST)
    ResponseData<MemberDistributionShareVo> getSharePosters(@RequestBody @Valid MemberDistributionShareVo vo);

    @RequestMapping(value = "/commissionExchangeIntegral", method = RequestMethod.POST)
    ResponseData commissionExchangeIntegral(@RequestBody MemberDistributionPageVo vo);

}
