package com.bizvane.customized.facade.interfaces;


import com.bizvane.customized.facade.models.vo.*;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.validation.Valid;
import java.util.List;

@FeignClient(value = "${feign.client.customized.name}", path = "${feign.client.customized.path}/ur/giftCardRpc")
@Api(tags = {"礼品卡RPC接口"}, description = "与线下交互接口")
public interface GiftCardServiceFeign {

    /**
     * 礼品卡查询
     * @param vo
     * @return
     */
    @RequestMapping(value = "/querygiftcarddetail", method = RequestMethod.POST)
    ResponseData<GiftCardConsumeResponseVO> queryGiftCardDetail(@RequestBody @Valid GiftCardConsumeRequestVO vo);

    /**
     * 礼品卡核销
     * @param vo
     * @return
     */
    @RequestMapping(value = "/modifygiftcardverification", method = RequestMethod.POST)
    ResponseData modifyGiftCardVerification(@RequestBody @Valid GiftCardConsumeRequestVO vo);

    /**
     * 礼品卡修改
     * @param vo
     * @return
     */
    @RequestMapping(value = "/updategiftcard", method = RequestMethod.POST)
    ResponseData updateGiftCard(@RequestBody @Valid GiftCardConsumeRequestVO vo);

    /**
     * 礼品卡消费记录保存（单个）
     * @param vo
     * @return
     */
    @RequestMapping(value = "/savegiftcarddetail", method = RequestMethod.POST)
    ResponseData saveGiftCardDetail(@RequestBody @Valid GiftCardConsumeRequestVO vo);

    /**
     * 礼品卡消费记录保存（批量）
     * @param voList
     * @return
     */
    @RequestMapping(value = "/batchsavegiftcarddetail", method = RequestMethod.POST)
    ResponseData batchSaveGiftCardDetail(@RequestBody @Valid List<GiftCardConsumeRequestVO> voList);

}
