package com.bizvane.customized.facade.interfaces;


import javax.validation.Valid;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.bizvane.customized.facade.models.po.CusUrMbrEvaluationConfigPO;
import com.bizvane.customized.facade.models.po.CusUrMbrQuestionnaireOrderPO;
import com.bizvane.customized.facade.models.po.CusUrMbrQuestionnaireTemplatePO;
import com.bizvane.customized.facade.models.vo.CusUrMbrEvalConfigVO;
import com.bizvane.customized.facade.models.vo.CusUrMbrQuestionnaireTemplateVO;
import com.bizvane.customized.facade.models.vo.EvaluationOrderRequestVO;
import com.bizvane.customized.facade.models.vo.EvaluationSaveTempRequestVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;

import io.swagger.annotations.Api;

@FeignClient(value = "${feign.client.customized.name}", path = "${feign.client.customized.path}/ur/mbr/evaluationQuestionnaireRpc")
@Api(tags = {"问券RPC接口"}, description = "")
public interface EvaluationQuestionnaireFeign {

    /**
     * 问卷模块配置查询
     * @param vo
     * @return
     */
    @RequestMapping(value = "/queryEvalConfig", method = RequestMethod.POST)
    ResponseData<PageInfo<CusUrMbrEvaluationConfigPO>> queryEvalConfig(@RequestBody @Valid CusUrMbrEvalConfigVO vo) ;

    /**
     * 问卷模板查询templateCode、
     * 加sysBrandId
     * 加sysCompanyId
     * @param vo
     * @return
     */
    @RequestMapping(value = "/queryQuestionTemplate", method = RequestMethod.POST)
    ResponseData<CusUrMbrQuestionnaireTemplatePO> queryQuestionTemplate(@RequestBody @Valid CusUrMbrQuestionnaireTemplateVO vo);

    /**
     * 问卷回答详情查询
     * @param vo
     * @return
     */
    @RequestMapping(value = "/queryAnswerOrderDetail", method = RequestMethod.POST)
    ResponseData<CusUrMbrQuestionnaireOrderPO> queryAnswerOrderDetail(@RequestBody @Valid EvaluationOrderRequestVO vo);

    /**
     * 保存订单问卷
     * @param vo
     * @return
     */
    @RequestMapping(value = "/saveQuestionnaireOrder", method = RequestMethod.POST)
    ResponseData<String> saveQuestionnaireOrder(@RequestBody @Valid EvaluationSaveTempRequestVO vo);
}
