package com.bizvane.customized.facade.models.vo;

import com.bizvane.customized.facade.models.po.CusDistributionRegxPO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @Author: LiJC
 * @CreateTime: 2019/8/07.
 */
@Data
public class MemberDistributionRegxVo extends CusDistributionRegxPO {

    @ApiModelProperty(name = "sysCompanyId", value = "企业id")
    private Long sysCompanyId;

    @ApiModelProperty(name = "brandId",value = "品牌id")
    private Long brandId;

    @ApiModelProperty(name = "commissionName",value = "佣金名称")
    private String commissionName;

    @ApiModelProperty(value = "佣金兑换方式 1兑换积分",name = "commissionExchangeType")
    private Integer commissionExchangeType;

    @ApiModelProperty(value = "佣金金额",name = "commission")
    private Integer commission;

    @ApiModelProperty(value = "积分余额",name = "integral")
    private Integer integral;

    @ApiModelProperty(value = "佣金兑换说明",name = "exchangeDescription")
    private String exchangeDescription;

    @ApiModelProperty(value = "获取佣金方式 1.线下门店消费",name = "commissionObtainType")
    private Integer commissionObtainType;

    @ApiModelProperty(value = "获取佣金方式层级二 1.以分销员所属门店为准 2.不限制",name = "commissionObtainDetailType")
    private Integer commissionObtainDetailType;

    @ApiModelProperty(value = "佣金比例规则",name = "commissionRation")
    private BigDecimal commissionRation;

    @ApiModelProperty(value = "佣金到账周期",name = "commissionPeriod")
    private Integer commissionPeriod;

    @ApiModelProperty(value = "业绩归属 1绑定，关系链为准",name = "tradeOwn")
    private Integer tradeOwn;

    @ApiModelProperty(value = "关系绑定类型 1永久",name = "bindRelation")
    private Integer bindRelation;

    @ApiModelProperty(value = "绑定条件1注册/绑卡",name = "bindCriteria")
    private Integer bindCriteria;

    @ApiModelProperty(value = "小程序分享图url",name = "miniProgramShareUrl")
    private String miniProgramShareUrl;

    @ApiModelProperty(value = "小程序分享图标题",name = "miniProgramShareTitle")
    private String miniProgramShareTitle;

    @ApiModelProperty(value = "小程序分享规则",name = "miniProgramShareDescription")
    private String miniProgramShareDescription;

    @ApiModelProperty(value = "海报背景图url",name = "backgroundUrl")
    private String backgroundUrl;

    @ApiModelProperty(value = "会员分销规则",name = "commissionRegular")
    private String commissionRegular;

    @ApiModelProperty(value = "分销状态 1启用 2禁用",name = "commissionStatus")
    private Integer commissionStatus;

    private Long operatorId;

    private String operatorName;

    private String distinct;
}
