package com.bizvane.crypto.utils;

import java.nio.charset.StandardCharsets;
import org.bouncycastle.crypto.digests.SM3Digest;

public class SM3Utils {
    /**
     * 生成 SM4 加密密钥
     * @param deviceId 用户设备 ID
     */
    public static String generateKeyHex(String deviceId) {
        try {
            byte[] deviceIdBytes = deviceId.getBytes(StandardCharsets.UTF_8);
            SM3Digest sm3Digest = new SM3Digest();
            sm3Digest.update(deviceIdBytes, 0, deviceIdBytes.length);
            byte[] hash = new byte[sm3Digest.getDigestSize()];
            sm3Digest.doFinal(hash, 0);
            byte[] sm4KeyBytes = new byte[16];
            System.arraycopy(hash, 0, sm4KeyBytes, 0, 16);
            return byteArrayToHex(sm4KeyBytes);
        }catch (Exception e){
            throw new RuntimeException(String.format("基于deviceId生成加密密钥异常，deviceId:%s",deviceId),e);
        }
    }

    public static String byteArrayToHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }
}
