package com.bizvane.trace.service.impl;

import brave.Tracing;
import brave.internal.HexCodec;
import brave.propagation.TraceContext;
import com.bizvane.trace.service.TraceService;

/**
 * @author dingShiChen
 * @since 2019/8/5
 */
public class CrmTraceServiceImpl implements TraceService {

	private Tracing tracing;

	public CrmTraceServiceImpl(Tracing tracing){
		this.tracing = tracing;
	}

	@Override
	public String trace() {
		TraceContext traceContext = getTraceContext();
		return traceContext.traceIdString();
	}

	@Override
	public String span() {
		TraceContext traceContext = getTraceContext();
		return HexCodec.toLowerHex(traceContext.spanId());
	}

	@Override
	public String traceWithSpan() {
		TraceContext traceContext = getTraceContext();
		return traceContext.toString();
	}

	private TraceContext getTraceContext(){
		return tracing.currentTraceContext().get();
	}
}
