package com.bizvane.trace.conf;

import com.bizvane.trace.aop.MethodTraceAspect;
import com.bizvane.trace.aop.RequestTraceAspect;
import com.bizvane.trace.service.ProvisionalTraceService;
import com.bizvane.trace.service.TraceService;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import javax.servlet.http.HttpServletResponse;

/**
 * @author dingShiChen
 * @since 2019/9/6
 */
@Configuration
@AutoConfigureAfter(CrmTraceAutoConfiguration.class)
public class TraceAopAutoConfiguration {

	@Bean
	@ConditionalOnMissingBean
	@ConditionalOnWebApplication
	@ConditionalOnBean(TraceService.class)
	public RequestTraceAspect traceAspect(TraceService traceService, HttpServletResponse response){
		return new RequestTraceAspect(traceService, response);
	}

	@Bean
	@ConditionalOnBean(ProvisionalTraceService.class)
	@ConditionalOnMissingBean
	public MethodTraceAspect methodTraceAspect(ProvisionalTraceService provisionalTraceService){
		return new MethodTraceAspect(provisionalTraceService);
	}
}
