package com.bizvane.trace.aop;

import com.bizvane.trace.service.TraceService;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.core.annotation.Order;

import javax.servlet.http.HttpServletResponse;

/**
 * 链路注入
 * @author dingShiChen
 * @since 2019/8/23
 */
@Aspect
@Order(1)
public class RequestTraceAspect {

	private TraceService traceService;
	private HttpServletResponse response;

	private static final String TRACE_NAME = "bizvane-trace";

	public RequestTraceAspect(TraceService traceService, HttpServletResponse response) {
		this.traceService = traceService;
		this.response = response;
	}

	@Pointcut("(execution(* com.bizvane..*.*(..))) " +
			"&& (@within(org.springframework.stereotype.Controller) || @within(org.springframework.web.bind.annotation.RestController)) " +
			"&& (@annotation(org.springframework.web.bind.annotation.RequestMapping) || @annotation(org.springframework.web.bind.annotation.PostMapping))")
	public void control(){

	}

	/**
	 * 在方法前就注入，方法后可能会被其他代理错过
	 * @param joinPoint
	 */
	@Before("control()")
	public void cutTrace(JoinPoint joinPoint){
		response.setHeader(TRACE_NAME, traceService.trace());
	}
}
