package com.bizvane.trace.aop;

import com.bizvane.trace.service.ProvisionalTraceService;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;

/**
 * @author dingShiChen
 * @since 2019/9/6
 */
@Aspect
public class MethodTraceAspect {

	private ProvisionalTraceService provisionalTraceService;

	public MethodTraceAspect(ProvisionalTraceService provisionalTraceService) {
		this.provisionalTraceService = provisionalTraceService;
	}

	@Around("@annotation(com.bizvane.trace.annotation.TraceWeaving)")
	public Object join(ProceedingJoinPoint joinPoint) throws Throwable {
		provisionalTraceService.start();
		try {
			return joinPoint.proceed();
		} finally {
			provisionalTraceService.finish();
		}
	}
}
