/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.oaserver.service.impl;

import cn.bizvane.openapi.client.sdk.SignatureUtils;
import com.alibaba.fastjson.JSON;
import com.bizvane.oaserver.exception.OpenApiCheckException;
import com.bizvane.oaserver.properties.OpenApiProperties;
import com.bizvane.oaserver.service.OpenApiHeaderService;
import com.bizvane.oaserver.service.OpenApiServerCheckService;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOpenApiServerCheckServiceImpl
implements OpenApiServerCheckService {
    private Logger log = LoggerFactory.getLogger(DefaultOpenApiServerCheckServiceImpl.class);
    private OpenApiProperties openApiProperties;
    private OpenApiHeaderService openApiHeaderService;

    public DefaultOpenApiServerCheckServiceImpl(OpenApiProperties openApiProperties, OpenApiHeaderService openApiHeaderService) {
        this.openApiProperties = openApiProperties;
        this.openApiHeaderService = openApiHeaderService;
    }

    @Override
    public void check(Object param) throws OpenApiCheckException {
        this.checkAppkey();
        this.checkSign(param);
    }

    private void checkAppkey() throws OpenApiCheckException {
        String appkeyFromConfig = this.openApiProperties.getAppkey();
        String appKeyFromClient = this.openApiHeaderService.getAppKeyFromClient();
        if (appkeyFromConfig == null || appKeyFromClient == null) {
            throw new OpenApiCheckException("get appkey error!");
        }
        if (!appkeyFromConfig.equals(appKeyFromClient)) {
            this.log.error("check appkey is fail!  : appkeyFromConfig : {}, appKeyFromClient : {}", (Object)appkeyFromConfig, (Object)appKeyFromClient);
            throw new OpenApiCheckException("check appkey is fail!");
        }
    }

    private void checkSign(Object param) throws OpenApiCheckException {
        String body = JSON.toJSONString((Object)param);
        HashMap<String, Object> map = new HashMap<String, Object>((Map<String, Object>)JSON.parseObject((String)body));
        map.putAll(this.openApiHeaderService.getNeedCheckParamsFromClient());
        String sign = SignatureUtils.sign((String)this.openApiProperties.getAppsecret(), map);
        String signFromClient = this.openApiHeaderService.getSignFromClient();
        if (signFromClient == null) {
            throw new OpenApiCheckException("get sign error!");
        }
        if (!sign.equals(signFromClient)) {
            this.log.error("check sign is fail!  : signFromClient : {}, sign : {}", (Object)signFromClient, (Object)sign);
            throw new OpenApiCheckException("check sign is fail!");
        }
    }
}

