/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.oaserver.aop;

import com.bizvane.oaserver.service.OpenApiServerCheckService;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.core.annotation.Order;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestBody;

@Aspect
public class OpenApiServerAspect {
    private OpenApiServerCheckService openApiServerCheckService;

    public OpenApiServerAspect(OpenApiServerCheckService openApiServerCheckService) {
        this.openApiServerCheckService = openApiServerCheckService;
    }

    @Around(value="@annotation(com.bizvane.oaserver.annotation.OpenApiServer)")
    @Order(value=1)
    public Object checkSign(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Method method = methodSignature.getMethod();
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        Object[] args = joinPoint.getArgs();
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            for (Annotation annotation : parameterAnnotations[i]) {
                if (!(annotation instanceof RequestBody)) continue;
                Assert.notNull((Object)args[i], (String)"@requestbody param is null!");
                this.openApiServerCheckService.check(args[i]);
            }
        }
        return joinPoint.proceed();
    }
}

