package com.bizvane.couponfacade.models.po;
/*
 * Created by JiangWenjian on 2021-05-19.
 */

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author jiangwenjian
 * @version 0.0.1
 * @since 0.0.1 2021-05-19
 */
@Data
public class CouponEntityYzDtoPO implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long couponEntityId;
    private BigDecimal money;
    private Boolean isUse;
    private String couponStatus;
    private String couponCode;
    private String couponDefinitionId;
    private Long sysCompanyId;
    private Long sysBrandId;
    private String brandCode;
    private String businessName;
    private String couponName;
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date validDateStart;
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date validDateEnd;
    private String memberCode;
    private BigDecimal discount;
    private Long couponBatchSendRecordId;
    private Long preferentialType;
    private Boolean isLock;
    private String usePassword;
    private String sendType;
    private String useType;
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date useTime;
    private Long createUserId;
    private String createUserName;
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createDate;
    private String phone;
}
