package com.bizvane.couponfacade.models.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @author baofeng@bizvane.cn
 * @createTime 2021-10-18 10:32:38
 * @description: 查询优惠券列表请求对象
 */
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Data
public class CouponQueryDTO {
    @ApiModelProperty(name = "cardCode", value = "会员卡号", required = true, example = "")
    private String cardCode;
    
    @ApiModelProperty(name = "couponCode", value = "券号")
    private String couponCode;

    @NotNull(message = "品牌ID不能为空")
    @ApiModelProperty(name = "brandId", value = "品牌ID", required = false, example = "")
    private Long brandId;

    @ApiModelProperty(name = "sysCompanyId", value = "企业ID", required = false, example = "")
    private Long sysCompanyId;

    @ApiModelProperty(name = "couponStatus", value = "5-线上绑定，10-同步中，11-同步失败，12-同步成功，20-未使用，25-已过期，30-已核销", required = false, example = "")
    private Integer couponStatus;

}
