package com.bizvane.couponfacade.models.vo;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.ibatis.annotations.AutomapConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 券已转赠VO
 * @author bizvane
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class CouponRecordTransferVO implements Serializable{

    /**
     * 券编号
     */
    private String couponCode;

    /**
     * 券名称
     */
    private String couponName;

    /**
     * 优惠类型（1现金，2折扣，3礼品）
     */
    private Byte preferentialType;

    /**
     * 转赠时间
     */
    private Date giveDate;

    /**
     * 领取时间
     */
    private Date receiveDate;

    /**
     * 领取人手机号
     */
    private String receivePhone;

    /**
     * 券定义ID
     */
    private Long couponDefinitionId;

    /**
     * 券实体ID
     */
    private Long couponEntityId;

}
