package com.bizvane.couponfacade.models.bo;

import lombok.Data;

import java.util.Map;

import io.swagger.annotations.ApiModelProperty;

/**
 * @author lijiachun
 */
@Data
public class CouponDetailsDto {

    @io.swagger.annotations.ApiModelProperty(value = "券凭证Id", name = "kdtId", required = false, example = "")
    private Long  id;
    @io.swagger.annotations.ApiModelProperty(value = "三方活动id", name = "kdtId", required = false, example = "")
    private Long activityId;
    @io.swagger.annotations.ApiModelProperty(value = "1-代金券 2-折扣券", name = "kdtId", required = false, example = "")
    private Long  preferentialMode;
    @io.swagger.annotations.ApiModelProperty(value = "优惠面额- 代金券类型，单位分 - 折扣券类型，真实折扣等于 value/10，如9.5折，value = 95   ", name = "kdtId", required = false, example = "")
    private Long value;
    @io.swagger.annotations.ApiModelProperty(value = "面额 CNY - 人民币(目前仅支持) USD - 美金 HKD - 港币", name = "kdtId", required = false, example = "")
    private String  currency;
    @io.swagger.annotations.ApiModelProperty(value = "用户id", name = "phone", required = false, example = "")
    private String phone;
    @io.swagger.annotations.ApiModelProperty(value = "凭证状态： 1.已领取未使用 2.已使用 3.未使用已过期", name = "kdtId", required = false, example = "")
    private Integer status;
    @io.swagger.annotations.ApiModelProperty(value = "凭证有效期开始时间", name = "kdtId", required = false, example = "")
    private String validStartTime;
    @io.swagger.annotations.ApiModelProperty(value = "凭证有效期结束时间", name = "kdtId", required = false, example = "")
    private String validEndTime;
    @io.swagger.annotations.ApiModelProperty(value = "凭证发放时间", name = "kdtId", required = false, example = "")
    private String sentAt;
    @io.swagger.annotations.ApiModelProperty(value = "核销码", name = "kdtId", required = false, example = "")
    private String verifyCode;
    @io.swagger.annotations.ApiModelProperty(value = "扩展字段 ", name = "pageNum", required = false, example = "")
    private Map<String,Object> extMap;
    
    @ApiModelProperty(value = "有赞openId", name = "yzOpenId")
    private String yzOpenId;
}
