package com.bizvane.couponfacade.models.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author dingShiChen
 * @since 2019/6/25
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("创建员工券任务VO")
public class EmpCouponTaskCreateVO implements Serializable {

	private static final long serialVersionUID = 728759453768392758L;

	@ApiModelProperty(value = "券定义id", required = true)
	private Long couponDefinitionId;

	@ApiModelProperty(value = "任务名称", required = true)
	private String taskName;

	@ApiModelProperty(value = "员工excel链接", required = true)
	private String link;

	@ApiModelProperty(value = "单个员工绑定数量", required = true)
	private Integer singleBindNumber;

	@ApiModelProperty(value = "发送类型：1-立即发送，2-指定时间", required = true)
	private Byte sendType;

	@ApiModelProperty(value = "发送时间", required = false)
	private String sendTimeStr;

}
