package com.bizvane.couponfacade.models.vo;

import com.bizvane.couponfacade.models.bo.CompanyBrandBO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

/**
 * @author dingShiChen
 * @since 2019/9/8
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("发送天猫券业务VO")
public class SimpleSendTmallCouponVO {

	@NotNull
	@ApiModelProperty(value = "企业品牌", required = true)
	private CompanyBrandBO companyBrand;

	@NotEmpty
	@ApiModelProperty(value = "会员code", required = true)
	private String memberCode;

	@NotEmpty
	@ApiModelProperty(value = "天猫昵称", required = true)
	private String tmallNick;

	@NotNull
	@ApiModelProperty(value = "券定义id", required = true)
	private Long couponDefinitionId;

	@NotNull
	@ApiModelProperty(value = "发送数量，不传默认是1")
	private Integer count;

	@ApiModelProperty(value = "业务单id")
	private Long sendBussienId;
}
