package com.bizvane.couponfacade.models.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.List;

@Data
@ToString
public class SendCouponSimpleRequestVO implements Serializable {

  
  
    public SendCouponSimpleRequestVO() {
    super();
  }

    public SendCouponSimpleRequestVO(SendCouponAsyncRequestBO bo) {
    super();
    this.memberCode = bo.getMemberCode();
    this.couponDefinitionId = bo.getCouponDefinitionId();
    this.sendType = bo.getSendType();
    this.sendBussienId = bo.getSendBussienId();
    this.businessName = bo.getBusinessName();
    this.brandId = bo.getBrandId();
    this.companyId = bo.getCompanyId();
    this.brandCode = bo.getBrandCode();
    this.taskId = bo.getTaskId();
    this.tmallNick = bo.getTmallNick();
    this.manualId = bo.getManualId();
    this.sendGuideId = bo.getSendGuideId();
    this.couponQuotaId = bo.getCouponQuotaId();
    this.sendGuideIdList = bo.getSendGuideIdList();
    this.sendCouponQuantity = bo.getSendCouponQuantity();
    this.mktGiftBagId = bo.getMktGiftBagId();
    this.mktGiftBagName = bo.getMktGiftBagName();
    this.isGiftBagLastCoupon = bo.getIsGiftBagLastCoupon();
    this.maVersionCode = bo.getMaVersionCode();
    this.maPlanCode = bo.getMaPlanCode();
    this.maPlanName = bo.getMaPlanName();
    this.maPlanNodeCode = bo.getMaPlanNodeCode();
    this.maBatchNumber = bo.getMaBatchNumber();
    this.maBatchSerialNumber = bo.getMaBatchSerialNumber();
    }

    /**
     *
     */
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "会员code", name = "memberCode", required = false, example = "")
    private String memberCode;

    @ApiModelProperty(value = "券定义id", name = "couponDefinitionId", required = false, example = "")
    private Long couponDefinitionId;

    @ApiModelProperty(value = "发送类型", name = "sendType", required = false, example = "")
    private String sendType;

    @ApiModelProperty(value = "业务id", name = "sendBussienId", required = false, example = "")
    private Long sendBussienId;

    @ApiModelProperty(value = "任务名称", name = "businessName", required = false, example = "")
    private String businessName;

    @ApiModelProperty(value = "品牌id", name = "brandId", required = false, example = "")
    private Long brandId;

    @ApiModelProperty(value = "企业id", name = "companyId", required = false, example = "")
    private Long companyId;

    @ApiModelProperty(value = "品牌号", name = "brandCode", required = false, example = "")
    private String brandCode;
    
    @ApiModelProperty(value = "涨红包taskId", name = "taskId", required = false, example = "")
    private String taskId;

    @ApiModelProperty(value = "天猫昵称", name = "tmallNick", required = false, example = "")
    private String tmallNick;

    @ApiModelProperty(value = "发卷任务id(生成异业券id)", name = "manualId", required = false, example = "")
    private Long manualId;

    @ApiModelProperty(value = "导购id", name = "sendGuideId", required = false, example = "")
    private Long sendGuideId;
    //券配额(导购)
    private Long couponQuotaId;
    @ApiModelProperty(value = "导购id集合", name = "sendGuideIdList", required = false, example = "")
    private List<Long> sendGuideIdList;

    @ApiModelProperty(value = "发券数量", name = "sendCouponQuantity", required = false, example = "")
    private Integer sendCouponQuantity = 1;

    @ApiModelProperty(value = "礼包id", name = "mktGiftBagId", required = false, example = "")
    private Long mktGiftBagId;

    @ApiModelProperty(value = "礼包名称", name = "mktGiftBagName", required = false, example = "")
    private String mktGiftBagName;

    @ApiModelProperty(value = "是否为礼包中最后一张券(0否1是)", name = "isGiftBagLastCoupon", required = false, example = "")
    private Byte isGiftBagLastCoupon = 0;

    //领券接口使用,若不为空则为券不同步线下
    @ApiModelProperty(value = "券号", name = "couponCode", required = false, example = "")
    private String couponCode;

    @ApiModelProperty(value = "发放平台", name = "sendPlatform")
    private String sendPlatform;

    @ApiModelProperty(value = "来源code", name = "sendSourceCode")
    private String sendSourceCode;

    @ApiModelProperty(value = "CDP营销流程版本编号", name = "maVersionCode", required = false, example = "")
    private String maVersionCode;

    @ApiModelProperty(value = "CDP营销流程编号", name = "maPlanCode", required = false, example = "")
    private String maPlanCode;

    @ApiModelProperty(value = "CDP营销流程名称", name = "maPlanName", required = false, example = "")
    private String maPlanName;

    @ApiModelProperty(value = "CDP营销流程节点编号", name = "maPlanNodeCode", required = false, example = "")
    private String maPlanNodeCode;

    @ApiModelProperty(value = "CDP发送批次号", name = "maBatchNumber", required = false, example = "")
    private String maBatchNumber;

    @ApiModelProperty(value = "CDP营销流程发送时生成的批次内的唯一序号",name = "maBatchSerialNumber")
    private String maBatchSerialNumber;

    public String getCouponCode() {
        return couponCode;
    }

    public void setCouponCode(String couponCode) {
        this.couponCode = couponCode;
    }

    public String getTaskId() {
		return taskId;
	}

	public void setTaskId(String taskId) {
		this.taskId = taskId;
	}

	public String getBusinessName() {
        return businessName;
    }

    public void setBusinessName(String businessName) {
        this.businessName = businessName;
    }

    public Long getBrandId() {
        return brandId;
    }

    public void setBrandId(Long brandId) {
        this.brandId = brandId;
    }

    public Long getCompanyId() {
        return companyId;
    }

    public void setCompanyId(Long companyId) {
        this.companyId = companyId;
    }

    public String getMemberCode() {
        return memberCode;
    }

    public void setMemberCode(String memberCode) {
        this.memberCode = memberCode;
    }

    public Long getCouponDefinitionId() {
        return couponDefinitionId;
    }

    public void setCouponDefinitionId(Long couponDefinitionId) {
        this.couponDefinitionId = couponDefinitionId;
    }

    public String getSendType() {
        return sendType;
    }

    public void setSendType(String sendType) {
        this.sendType = sendType;
    }

    public Long getSendBussienId() {
        return sendBussienId;
    }

    public void setSendBussienId(Long sendBussienId) {
        this.sendBussienId = sendBussienId;
    }

    public String getBrandCode() {
        return brandCode;
    }

    public void setBrandCode(String brandCode) {
        this.brandCode = brandCode;
    }

    public String getTmallNick() {
        return tmallNick;
    }

    public void setTmallNick(String tmallNick) {
        this.tmallNick = tmallNick;
    }

    public Long getManualId() {
        return manualId;
    }

    public void setManualId(Long manualId) {
        this.manualId = manualId;
    }

    public Long getSendGuideId() {
        return sendGuideId;
    }

    public void setSendGuideId(Long sendGuideId) {
        this.sendGuideId = sendGuideId;
    }

    public Long getCouponQuotaId() {
        return couponQuotaId;
    }

    public void setCouponQuotaId(Long couponQuotaId) {
        this.couponQuotaId = couponQuotaId;
    }

    public List<Long> getSendGuideIdList() {
        return sendGuideIdList;
    }

    public void setSendGuideIdList(List<Long> sendGuideIdList) {
        this.sendGuideIdList = sendGuideIdList;
    }

    public Integer getSendCouponQuantity() {
        return sendCouponQuantity;
    }

    public void setSendCouponQuantity(Integer sendCouponQuantity) {
        this.sendCouponQuantity = sendCouponQuantity;
    }

    public Long getMktGiftBagId() {
        return mktGiftBagId;
    }

    public void setMktGiftBagId(Long mktGiftBagId) {
        this.mktGiftBagId = mktGiftBagId;
    }

    public String getMktGiftBagName() {
        return mktGiftBagName;
    }

    public void setMktGiftBagName(String mktGiftBagName) {
        this.mktGiftBagName = mktGiftBagName;
    }

    public Byte getIsGiftBagLastCoupon() {
        return isGiftBagLastCoupon;
    }

    public void setIsGiftBagLastCoupon(Byte isGiftBagLastCoupon) {
        this.isGiftBagLastCoupon = isGiftBagLastCoupon;
    }


    public String getMaVersionCode() {
        return maVersionCode;
    }

    public void setMaVersionCode(String maVersionCode) {
        this.maVersionCode = maVersionCode;
    }

    public String getMaPlanCode() {
        return maPlanCode;
    }

    public void setMaPlanCode(String maPlanCode) {
        this.maPlanCode = maPlanCode;
    }

    public String getMaPlanName() {
        return maPlanName;
    }

    public void setMaPlanName(String maPlanName) {
        this.maPlanName = maPlanName;
    }

    public String getMaPlanNodeCode() {
        return maPlanNodeCode;
    }

    public void setMaPlanNodeCode(String maPlanNodeCode) {
        this.maPlanNodeCode = maPlanNodeCode;
    }

    public String getMaBatchNumber() {
        return maBatchNumber;
    }

    public void setMaBatchNumber(String maBatchNumber) {
        this.maBatchNumber = maBatchNumber;
    }

    public void setMaBatchSerialNumber(String maBatchSerialNumber) {
        this.maBatchSerialNumber = maBatchSerialNumber;
    }

    public String getMaBatchSerialNumber() {
        return maBatchSerialNumber;
    }
}
