package com.bizvane.couponfacade.interfaces;

import com.bizvane.couponfacade.models.bo.SendCouponWebhookRequest;
import com.bizvane.couponfacade.models.po.CouponEntityPO;
import com.bizvane.couponfacade.models.vo.*;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

@FeignClient(value="${feign.client.coupon.name}",path="${feign.client.coupon.path}/sendCoupon")
@Api(value = "发券",tags = {"API"})
public interface SendCouponServiceFeign {
    
    /**
     * 单张发券
     * @return
     */
    @ApiOperation(value = "单张发券接口", notes = "单张发券接口", tags = {"券消息配置"},httpMethod = "POST")
    @RequestMapping(value="/simple", method = RequestMethod.POST)
    @Deprecated
    ResponseData<String> simple(@RequestBody(required = false) SendCouponSimpleRequestVO vo);

    /**
     * 单张发券异步
     * @return
     */
    @ApiOperation(value = "单张发券异步接口", notes = "单张发券接口",httpMethod = "POST")
    @RequestMapping(value="/simpleAsync", method = RequestMethod.POST)
    ResponseData<String> simpleAsync(@RequestBody SendCouponAsyncRequestBO bo);
    
    
    /**
     * 发送天猫券，支持单个目标人、多张券发送
     * @return
     */
    @PostMapping("/simpleSendTmallCoupon")
    @ApiOperation(value = "天猫券发送", notes = "批量发券接口", tags = {"发券"}, httpMethod = "POST")
    ResponseData simpleSendTmallCoupon(@RequestBody SimpleSendTmallCouponVO vo);
    
    /**
     * 批量发券
     * @return
     */
    /*@ApiOperation(value = "批量发券接口", notes = "批量发券接口", tags = {"券消息配置"},httpMethod = "POST")
    @RequestMapping(value="/batch", method = RequestMethod.POST)
    ResponseData<Object> batch(@RequestBody SendCouponBatchRequestVO vo);*/


    /**
     * 批量发券
     * @return
     */
    @ApiOperation(value = "批量发券接口", notes = "批量发券接口", tags = {"券消息配置"},httpMethod = "POST")
    @RequestMapping(value="/batchRpc", method = RequestMethod.POST)
    ResponseData<Object> batchCoupon(@RequestBody SendCouponBatchRequestVO vo);

    /**
     * 批量发券-支付宝商家券
     *
     * @return
     */
    @ApiOperation(value = "支付宝商家券批量发券接口", notes = "支付宝商家券批量发券接口", tags = {"发券"}, httpMethod = "POST")
    @PostMapping("/batchAlipayCoupon")
    ResponseData<Long> batchAlipayCoupon(@RequestBody @Valid PreGeneratedCouponAlipayTaskCreateVO vo);
    
    
    /**
     * 批量发券
     * @return
     */
    @ApiOperation(value = "企业微信批量发券接口", notes = "企业微信批量发券接口", tags = {"券消息配置"},httpMethod = "POST")
    @RequestMapping(value="/couponQuotaBatchRpc", method = RequestMethod.POST)
    ResponseData<Object> couponQuotaBatchRpc(@RequestBody SendCouponQuotaBatchRequestVO vo);


    /**
     * 券到期提醒
     * @param expireDay
     * @return
     */
    @ApiOperation(value = "券到期提醒", notes = "券到期提醒", tags = {"发券"},httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "expireDay", value = "过期时间", required = true, dataType = "String")
    })
    @RequestMapping("/expire")
    public ResponseData<Integer> expire(@RequestParam(value = "expireDay",required = false) String expireDay);

    /**
     * 异步单张发券
     * @return
     */
    @ApiOperation(value = "异步单张发券接口", notes = "异步单张发券接口", tags = {"发券"},httpMethod = "POST")
    @RequestMapping(value="/asyncSimple", method = RequestMethod.POST)
    ResponseData<String> asyncSimple(@RequestBody(required = false) SendCouponAsyncSimpleRequestVO vo);


    /**
     * 361会员领券接口
     */
    @ApiOperation(value = "361会员领券接口", notes = "361会员领券接口", tags = {"发券"},httpMethod = "POST")
    @RequestMapping(value="/simpleOf361", method = RequestMethod.POST)
    ResponseData<CouponEntityPO> simpleOf361(@RequestBody(required = false) SendCoupon361SimpleRequestVO vo);

    @ApiOperation(value = "361神策Webhook发券接口", notes = "361神策Webhook发券接口", tags = {"发券"},httpMethod = "POST")
    @RequestMapping(value="/webhookSendCoupon", method = RequestMethod.POST)
    ResponseData<Object> webhookSendCoupon(@RequestBody(required = false) SendCouponWebhookRequest request);

    /**
     * ur会员领券接口
     */
    @ApiOperation(value = "ur会员领券接口", notes = "ur会员领券接口", tags = {"发券"},httpMethod = "POST")
    @RequestMapping(value="/simpleOfur", method = RequestMethod.POST)
    ResponseData<CouponInfoVo> simpleOfur(@RequestBody(required = false) SendCouponUrSimpleRequestVO vo);


    /**
     * 积分商城  商秀
     * 异步批量发异业券接口 必传参数:manualId,memberCode,couponDefinitionId,sendType,sendBussienId,brandId,companyId
     * @return
     */
    @ApiOperation(value = "异步批量发异业券接口", notes = "异步批量发异业券接口", tags = {"发券"},httpMethod = "POST")
    @PostMapping("/asyncBatchSendDifindustry")
    ResponseData<String> asyncBatchSendDifindustry(@RequestBody(required = false) @Valid List<SendCouponAsyncSimpleRequestVO> list);

    /**
     * 发异业券接口 必传参数:manualId,memberCode,couponDefinitionId,sendType,sendBussienId,brandId,companyId
     * @param vo
     * @return
     */
    @ApiOperation(value = "异步单发异业券接口", notes = "异步单发异业券接口", tags = {"发券"},httpMethod = "POST")
    @PostMapping("/asyncSimpleSendDifindustryCoupon")
    ResponseData<String> asyncSimpleSendDifindustryCoupon(@RequestBody @Valid SendCouponAsyncSimpleRequestVO vo);

    /**
     * 商秀发异业券券  提前锁定券池子
     * 必传参数:manualId,brandId,companyId,serviceGuideId,sendCouponQuantity
     * @param vo
     * @return
     */
    @ApiOperation(value = "商秀发异业券券提前锁定池子", notes = "商秀发异业券券提前锁定池子", tags = {"提前锁定池子"},httpMethod = "POST")
    @PostMapping("/reduceDifindustryCouponQuantity")
    ResponseData<String> reduceDifindustryCouponQuantity(@RequestBody @Valid CouponDefinitionVO vo);

    /**
     * 商秀发异业券券  释放券池子
     * 必传参数:manualId,brandId,companyId,serviceGuideId
     * @param vo
     * @return
     */
    @ApiOperation(value = "商秀发异业券券释放券池子", notes = "商秀发异业券释放券池子", tags = {"释放券池子"},httpMethod = "POST")
    @PostMapping("/releaseDifindustryCouponQuantity")
    ResponseData<String> releaseDifindustryCouponQuantity(@RequestBody @Valid SendCouponSimpleRequestVO vo);
}
