package com.bizvane.couponfacade.models.po;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import io.swagger.annotations.ApiModelProperty;
/**
 * @author bizvane
 */
public class CouponDefinitionPO implements Serializable {

    /**
	 * 只读. pkid. coupon_definition_id
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "pkid", name = "couponDefinitionId")
	private Long couponDefinitionId;

	/**
	 * 只读. 所属企业id. sys_company_id
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "所属企业id", name = "sysCompanyId")
	private Long sysCompanyId;

	/**
	 * 只读. 所属品牌id. sys_brand_id
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "所属品牌id", name = "sysBrandId")
	private Long sysBrandId;

	/**
	 * 只读. 所属品牌编号. brand_code
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "所属品牌编号", name = "brandCode")
	private String brandCode;

	/**
	 * 只读. 券编号. coupon_definition_code
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "券编号", name = "couponDefinitionCode")
	private String couponDefinitionCode;

	/**
	 * 只读. 券定义类型：1-线上定义，2-erp生成. coupon_definition_type
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "券定义类型：1-线上定义，2-erp生成", name = "couponDefinitionType")
	private Byte couponDefinitionType;

	/**
	 * 只读. 线下券类型号. erp_coupon_definition_code
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "线下券类型号", name = "erpCouponDefinitionCode")
	private String erpCouponDefinitionCode;

	/**
	 * 只读. 券名称. coupon_name
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "券名称", name = "couponName")
	private String couponName;

	/**
	 * 只读. 渠道限制（1仅线下,2全渠道,3仅线上,4员工券,5天猫券, 6积分券）. use_channel
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "渠道限制（1仅线下,2全渠道,3仅线上,4员工券,5天猫券, 6积分券）", name = "useChannel")
	private Byte useChannel;

	/**
	 * 只读. 优惠类型（1现金,2折扣,3兑换,4积分）. preferential_type
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "优惠类型（1现金,2折扣,3兑换,4积分）", name = "preferentialType")
	private Byte preferentialType;

	/**
	 * 只读. 券的面额. money
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "券的面额", name = "money")
	private BigDecimal money;

	/**
	 * 只读. 券的折扣. discount
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "券的折扣", name = "discount")
	private BigDecimal discount;

	/**
	 * 只读. 有效期类型：1-日期区间，2-领取后X天有效，3-仅限会员生日当天使用，4-仅限会员生日当月使用 5 领取后X天生效 效期X天. valid_type
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "有效期类型：1-日期区间，2-领取后X天有效，3-仅限会员生日当天使用，4-仅限会员生日当月使用 5 领取后X天生效 效期X天", name = "validType")
	private Byte validType;

	/**
	 * 只读. 有效期开始时间. valid_date_start
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "有效期开始时间", name = "validDateStart")
	private Date validDateStart;

	/**
	 * 只读. 有效期结束时间. valid_date_end
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "有效期结束时间", name = "validDateEnd")
	private Date validDateEnd;

	/**
	 * 只读. 有效天数. valid_day
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "有效天数", name = "validDay")
	private Integer validDay;

	/**
	 * 只读. 二维码. qr_code
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "二维码", name = "qrCode")
	private String qrCode;

	/**
	 * 只读. 券模板图片. img
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "券模板图片", name = "img")
	private String img;

	/**
	 * 只读. 单人最大领取数量限制. per_max_num
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "单人最大领取数量限制", name = "perMaxNum")
	private Integer perMaxNum;

	/**
	 * 只读. 是否记名（1记名，0不记名）. is_real_name
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "是否记名（1记名，0不记名）", name = "isRealName")
	private Boolean isRealName;

	/**
	 * 只读. 是否允许转赠（1允许转赠，0不允许转赠）. is_transfer
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "是否允许转赠（1允许转赠，0不允许转赠）", name = "isTransfer")
	private Boolean isTransfer;

	/**
	 * 只读. 活动叠加条件：1-不允许叠加其他活动使用，2-允许叠加其他活动使用，3-允许部分活动使用. activity_superposition_type
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "活动叠加条件：1-不允许叠加其他活动使用，2-允许叠加其他活动使用，3-允许部分活动使用", name = "activitySuperpositionType")
	private Byte activitySuperpositionType;

	/**
	 * 只读. 活动叠加白名单. activity_superposition_white_list
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "活动叠加白名单", name = "activitySuperpositionWhiteList")
	private String activitySuperpositionWhiteList;

	/**
	 * 只读. 活动叠加黑名单. activity_superposition_black_list
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "活动叠加黑名单", name = "activitySuperpositionBlackList")
	private String activitySuperpositionBlackList;

	/**
	 * 只读. 是否允许叠加（1是，0否）. is_superposition
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "是否允许叠加（1是，0否）", name = "isSuperposition")
	private Boolean isSuperposition;

	/**
	 * 只读. 正价购买限制. is_tag_price_limit
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "正价购买限制", name = "isTagPriceLimit")
	private Boolean isTagPriceLimit;

	/**
	 * 只读. . tag_price_max_preferential_limit
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "", name = "tagPriceMaxPreferentialLimit")
	private BigDecimal tagPriceMaxPreferentialLimit;

	/**
	 * 只读. 最低消费金额(满减金额). min_consume
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "最低消费金额(满减金额)", name = "minConsume")
	private BigDecimal minConsume;

	/**
	 * 只读. 最高优惠金额. max_preferential
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "最高优惠金额", name = "maxPreferential")
	private BigDecimal maxPreferential;

	/**
	 * 只读. 商品数量限制类型：0-无限制，1-最低限制，2-最高限制. commodity_quantity_limit_type
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "商品数量限制类型：0-无限制，1-最低限制，2-最高限制", name = "commodityQuantityLimitType")
	private Integer commodityQuantityLimitType;

	/**
	 * 只读. 商品数量最低限制. min_commodity_num
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "商品数量最低限制", name = "minCommodityNum")
	private Integer minCommodityNum;

	/**
	 * 只读. 商品数量最高限制. max_commodity_num
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "商品数量最高限制", name = "maxCommodityNum")
	private Integer maxCommodityNum;

	/**
	 * 只读. 整单最低折扣限制. min_discount
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "整单最低折扣限制", name = "minDiscount")
	private BigDecimal minDiscount;

	/**
	 * 只读. 适用商品类型：1-全部适用，2-部分适用. appliance_commodity_type
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "适用商品类型：1-全部适用，2-部分适用", name = "applianceCommodityType")
	private Byte applianceCommodityType;

	/**
	 * 只读. 适用门店类型：1-全部适用，2-部分适用. appliance_store_type
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "适用门店类型：1-全部适用，2-部分适用", name = "applianceStoreType")
	private Byte applianceStoreType;

	/**
	 * 只读. 描述. info
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "描述", name = "info")
	private String info;

	/**
	 * 只读. 备注. remark
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "备注", name = "remark")
	private String remark;

	/**
	 * 只读. 券状态（1已启用，0已停用）. status
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "券状态（1已启用，0已停用）", name = "status")
	private Boolean status;

	/**
	 * 只读. 创建人id. create_user_id
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "创建人id", name = "createUserId")
	private Long createUserId;

	/**
	 * 只读. 创建人. create_user_name
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "创建人", name = "createUserName")
	private String createUserName;

	/**
	 * 只读. 创建时间. create_date
	 * @mbg.generated
	 */
	@JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
	@ApiModelProperty(value = "创建时间", name = "createDate")
	private Date createDate;

	/**
	 * 只读. 修改人id. modified_user_id
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "修改人id", name = "modifiedUserId")
	private Long modifiedUserId;

	/**
	 * 只读. 修改人. modified_user_name
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "修改人", name = "modifiedUserName")
	private String modifiedUserName;

	/**
	 * 只读. 修改时间. modified_date
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "修改时间", name = "modifiedDate")
	private Date modifiedDate;

	/**
	 * 只读. 数据有效性（1有效，0无效）. valid
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "数据有效性（1有效，0无效）", name = "valid")
	private Boolean valid;

	/**
	 * 只读. 添加到券自定义模板(1是，0否). is_add_template
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "添加到券自定义模板(1是，0否)", name = "isAddTemplate")
	private Boolean isAddTemplate;

	/**
	 * 只读. 券叠加条件(1-相同的券定义叠加  2-不相同的券定义叠加). coupon_superposition_type
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "券叠加条件(1-相同的券定义叠加  2-不相同的券定义叠加)", name = "couponSuperpositionType")
	private Byte couponSuperpositionType;

	/**
	 * 只读. 相同的券定义叠加，最多可叠加券数量. same_superposition_limit
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "相同的券定义叠加，最多可叠加券数量", name = "sameSuperpositionLimit")
	private Integer sameSuperpositionLimit;

	/**
	 * 只读. 不相同的券定义叠加，最多可叠加券数量. different_superposition_valid
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "不相同的券定义叠加，最多可叠加券数量", name = "differentSuperpositionValid")
	private Integer differentSuperpositionValid;

	/**
	 * 只读. 能否叠加会员卡使用（0-不能，1-能）. superposition_member_card
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "能否叠加会员卡使用（0-不能，1-能）", name = "superpositionMemberCard")
	private Boolean superpositionMemberCard;

	/**
	 * 只读. 可裂变1，不可以0. transfer_fission
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "可裂变1，不可以0", name = "transferFission")
	private Boolean transferFission;

	/**
	 * 只读. 转增后1核销送券，0不送券. transfer_send
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "转增后1核销送券，0不送券", name = "transferSend")
	private Boolean transferSend;

	/**
	 * 只读. 转增后要发的券定义id. transfer_coupon_definition_id
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "转增后要发的券定义id", name = "transferCouponDefinitionId")
	private Long transferCouponDefinitionId;

	/**
	 * 只读. 转增说明. transfer_info
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "转增说明", name = "transferInfo")
	private String transferInfo;

	/**
	 * 只读. 领取X天后生效. delay_day
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "领取X天后生效", name = "delayDay")
	private Integer delayDay;

	/**
	 * 只读. 领取X天后有效期X天. delay_valid_day
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "领取X天后有效期X天", name = "delayValidDay")
	private Integer delayValidDay;

	/**
	 * 只读. 商品类型. prd_parent_name
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "商品类型", name = "prdParentName")
	private String prdParentName;

	/**
	 * 只读. 线上组织code. organization_code
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "线上组织code", name = "organizationCode")
	private String organizationCode;

	/**
	 * 只读. 是否允许券数小于商品数,1:允许,0:不允许. is_coupon_less_goods
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "是否允许券数小于商品数,1:允许,0:不允许", name = "isCouponLessGoods")
	private String isCouponLessGoods;

	/**
	 * 只读. 商品条件限制. goods_condition
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "商品条件限制", name = "goodsCondition")
	private Integer goodsCondition;

	/**
	 * 只读. 是否退单退券(1 退单退券 0 退单不退券 ). charge_back
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "是否退单退券(1 退单退券 0 退单不退券 )", name = "chargeBack")
	private Byte chargeBack;

	/**
	 * 只读. 券过期是否延长有效期：1-延长，0-不延长. prolong_valid_date
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "券过期是否延长有效期：1-延长，0-不延长", name = "prolongValidDate")
	private Boolean prolongValidDate;

	/**
	 * 只读. 券过期延长有效期天数. prolong_valid_date_day
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "券过期延长有效期天数", name = "prolongValidDateDay")
	private Integer prolongValidDateDay;

	/**
	 * 只读. 自定义券背景图. coupon_background_url
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "自定义券背景图", name = "couponBackgroundUrl")
	private String couponBackgroundUrl;

	/**
	 * 只读. 劵背景设置（1系统默认 0 自定义背景图）. coupon_background_type
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "劵背景设置（1系统默认 0 自定义背景图）", name = "couponBackgroundType")
	private Boolean couponBackgroundType;

	/**
	 * 只读. 适用运营组织类型：1-全部适用，2-部分适用. appliance_org_type
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "适用运营组织类型：1-全部适用，2-部分适用", name = "applianceOrgType")
	private Integer applianceOrgType;

	/**
	 * 只读. 适用运营组织codes. appliance_org_codes
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "适用运营组织codes", name = "applianceOrgCodes")
	private String applianceOrgCodes;

	/**
	 * 只读. 微盟方券定义id. wm_coupon_definition_code
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "微盟方券定义id", name = "wmCouponDefinitionCode")
	private String wmCouponDefinitionCode;

	/**
	 * 只读. 跳转类型：0=不跳转；1=跳转. link_type
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "跳转类型：0=不跳转；1=跳转", name = "linkType")
	private Boolean linkType;

	/**
	 * 只读. 链接按钮名称. button_name
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "链接按钮名称", name = "buttonName")
	private String buttonName;

	/**
	 * 只读. 自定义链接按钮名称. button_name_custom
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "自定义链接按钮名称", name = "buttonNameCustom")
	private String buttonNameCustom;

	/**
	 * 只读. 链接按钮显示类型：0=券可使用时(未使用/未过期)；1=自定义；2=券到期. button_show_type
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "链接按钮显示类型：0=券可使用时(未使用/未过期)；1=自定义；2=券到期", name = "buttonShowType")
	private Integer buttonShowType;

	/**
	 * 只读. 链接按钮自定义显示开始时间. customize_start_time
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "链接按钮自定义显示开始时间", name = "customizeStartTime")
	private Date customizeStartTime;

	/**
	 * 只读. 链接按钮自定义显示结束时间. customize_end_time
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "链接按钮自定义显示结束时间", name = "customizeEndTime")
	private Date customizeEndTime;

	/**
	 * 只读. 券到期前几天. before_coupon_expire_day
	 * @mbg.generated
	 */
	@ApiModelProperty(value = "券到期前几天", name = "beforeCouponExpireDay")
	private Integer beforeCouponExpireDay;

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public Long getCouponDefinitionId() {
		return couponDefinitionId;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setCouponDefinitionId(Long couponDefinitionId) {
		this.couponDefinitionId = couponDefinitionId;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public Long getSysCompanyId() {
		return sysCompanyId;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setSysCompanyId(Long sysCompanyId) {
		this.sysCompanyId = sysCompanyId;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public Long getSysBrandId() {
		return sysBrandId;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setSysBrandId(Long sysBrandId) {
		this.sysBrandId = sysBrandId;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public String getBrandCode() {
		return brandCode;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setBrandCode(String brandCode) {
		this.brandCode = brandCode == null ? null : brandCode.trim();
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public String getCouponDefinitionCode() {
		return couponDefinitionCode;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setCouponDefinitionCode(String couponDefinitionCode) {
		this.couponDefinitionCode = couponDefinitionCode == null ? null : couponDefinitionCode.trim();
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public Byte getCouponDefinitionType() {
		return couponDefinitionType;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setCouponDefinitionType(Byte couponDefinitionType) {
		this.couponDefinitionType = couponDefinitionType;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public String getErpCouponDefinitionCode() {
		return erpCouponDefinitionCode;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setErpCouponDefinitionCode(String erpCouponDefinitionCode) {
		this.erpCouponDefinitionCode = erpCouponDefinitionCode == null ? null : erpCouponDefinitionCode.trim();
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public String getCouponName() {
		return couponName;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setCouponName(String couponName) {
		this.couponName = couponName == null ? null : couponName.trim();
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public Byte getUseChannel() {
		return useChannel;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setUseChannel(Byte useChannel) {
		this.useChannel = useChannel;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public Byte getPreferentialType() {
		return preferentialType;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setPreferentialType(Byte preferentialType) {
		this.preferentialType = preferentialType;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public BigDecimal getMoney() {
		return money;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setMoney(BigDecimal money) {
		this.money = money;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public BigDecimal getDiscount() {
		return discount;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setDiscount(BigDecimal discount) {
		this.discount = discount;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public Byte getValidType() {
		return validType;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setValidType(Byte validType) {
		this.validType = validType;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public Date getValidDateStart() {
		return validDateStart;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setValidDateStart(Date validDateStart) {
		this.validDateStart = validDateStart;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public Date getValidDateEnd() {
		return validDateEnd;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setValidDateEnd(Date validDateEnd) {
		this.validDateEnd = validDateEnd;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public Integer getValidDay() {
		return validDay;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setValidDay(Integer validDay) {
		this.validDay = validDay;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public String getQrCode() {
		return qrCode;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setQrCode(String qrCode) {
		this.qrCode = qrCode == null ? null : qrCode.trim();
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public String getImg() {
		return img;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setImg(String img) {
		this.img = img == null ? null : img.trim();
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public Integer getPerMaxNum() {
		return perMaxNum;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setPerMaxNum(Integer perMaxNum) {
		this.perMaxNum = perMaxNum;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public Boolean getIsRealName() {
		return isRealName;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setIsRealName(Boolean isRealName) {
		this.isRealName = isRealName;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public Boolean getIsTransfer() {
		return isTransfer;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setIsTransfer(Boolean isTransfer) {
		this.isTransfer = isTransfer;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public Byte getActivitySuperpositionType() {
		return activitySuperpositionType;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setActivitySuperpositionType(Byte activitySuperpositionType) {
		this.activitySuperpositionType = activitySuperpositionType;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public String getActivitySuperpositionWhiteList() {
		return activitySuperpositionWhiteList;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setActivitySuperpositionWhiteList(String activitySuperpositionWhiteList) {
		this.activitySuperpositionWhiteList = activitySuperpositionWhiteList == null ? null
		    : activitySuperpositionWhiteList.trim();
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public String getActivitySuperpositionBlackList() {
		return activitySuperpositionBlackList;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setActivitySuperpositionBlackList(String activitySuperpositionBlackList) {
		this.activitySuperpositionBlackList = activitySuperpositionBlackList == null ? null
		    : activitySuperpositionBlackList.trim();
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public Boolean getIsSuperposition() {
		return isSuperposition;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setIsSuperposition(Boolean isSuperposition) {
		this.isSuperposition = isSuperposition;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public Boolean getIsTagPriceLimit() {
		return isTagPriceLimit;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setIsTagPriceLimit(Boolean isTagPriceLimit) {
		this.isTagPriceLimit = isTagPriceLimit;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public BigDecimal getTagPriceMaxPreferentialLimit() {
		return tagPriceMaxPreferentialLimit;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setTagPriceMaxPreferentialLimit(BigDecimal tagPriceMaxPreferentialLimit) {
		this.tagPriceMaxPreferentialLimit = tagPriceMaxPreferentialLimit;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public BigDecimal getMinConsume() {
		return minConsume;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setMinConsume(BigDecimal minConsume) {
		this.minConsume = minConsume;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public BigDecimal getMaxPreferential() {
		return maxPreferential;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setMaxPreferential(BigDecimal maxPreferential) {
		this.maxPreferential = maxPreferential;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public Integer getCommodityQuantityLimitType() {
		return commodityQuantityLimitType;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setCommodityQuantityLimitType(Integer commodityQuantityLimitType) {
		this.commodityQuantityLimitType = commodityQuantityLimitType;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public Integer getMinCommodityNum() {
		return minCommodityNum;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setMinCommodityNum(Integer minCommodityNum) {
		this.minCommodityNum = minCommodityNum;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public Integer getMaxCommodityNum() {
		return maxCommodityNum;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setMaxCommodityNum(Integer maxCommodityNum) {
		this.maxCommodityNum = maxCommodityNum;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public BigDecimal getMinDiscount() {
		return minDiscount;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setMinDiscount(BigDecimal minDiscount) {
		this.minDiscount = minDiscount;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public Byte getApplianceCommodityType() {
		return applianceCommodityType;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setApplianceCommodityType(Byte applianceCommodityType) {
		this.applianceCommodityType = applianceCommodityType;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public Byte getApplianceStoreType() {
		return applianceStoreType;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setApplianceStoreType(Byte applianceStoreType) {
		this.applianceStoreType = applianceStoreType;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public String getInfo() {
		return info;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setInfo(String info) {
		this.info = info == null ? null : info.trim();
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public String getRemark() {
		return remark;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setRemark(String remark) {
		this.remark = remark == null ? null : remark.trim();
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public Boolean getStatus() {
		return status;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setStatus(Boolean status) {
		this.status = status;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public Long getCreateUserId() {
		return createUserId;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setCreateUserId(Long createUserId) {
		this.createUserId = createUserId;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public String getCreateUserName() {
		return createUserName;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setCreateUserName(String createUserName) {
		this.createUserName = createUserName == null ? null : createUserName.trim();
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public Date getCreateDate() {
		return createDate;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setCreateDate(Date createDate) {
		this.createDate = createDate;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public Long getModifiedUserId() {
		return modifiedUserId;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setModifiedUserId(Long modifiedUserId) {
		this.modifiedUserId = modifiedUserId;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public String getModifiedUserName() {
		return modifiedUserName;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setModifiedUserName(String modifiedUserName) {
		this.modifiedUserName = modifiedUserName == null ? null : modifiedUserName.trim();
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public Date getModifiedDate() {
		return modifiedDate;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setModifiedDate(Date modifiedDate) {
		this.modifiedDate = modifiedDate;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public Boolean getValid() {
		return valid;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setValid(Boolean valid) {
		this.valid = valid;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public Boolean getIsAddTemplate() {
		return isAddTemplate;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setIsAddTemplate(Boolean isAddTemplate) {
		this.isAddTemplate = isAddTemplate;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public Byte getCouponSuperpositionType() {
		return couponSuperpositionType;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setCouponSuperpositionType(Byte couponSuperpositionType) {
		this.couponSuperpositionType = couponSuperpositionType;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public Integer getSameSuperpositionLimit() {
		return sameSuperpositionLimit;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setSameSuperpositionLimit(Integer sameSuperpositionLimit) {
		this.sameSuperpositionLimit = sameSuperpositionLimit;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public Integer getDifferentSuperpositionValid() {
		return differentSuperpositionValid;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setDifferentSuperpositionValid(Integer differentSuperpositionValid) {
		this.differentSuperpositionValid = differentSuperpositionValid;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public Boolean getSuperpositionMemberCard() {
		return superpositionMemberCard;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setSuperpositionMemberCard(Boolean superpositionMemberCard) {
		this.superpositionMemberCard = superpositionMemberCard;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public Boolean getTransferFission() {
		return transferFission;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setTransferFission(Boolean transferFission) {
		this.transferFission = transferFission;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public Boolean getTransferSend() {
		return transferSend;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setTransferSend(Boolean transferSend) {
		this.transferSend = transferSend;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public Long getTransferCouponDefinitionId() {
		return transferCouponDefinitionId;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setTransferCouponDefinitionId(Long transferCouponDefinitionId) {
		this.transferCouponDefinitionId = transferCouponDefinitionId;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public String getTransferInfo() {
		return transferInfo;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setTransferInfo(String transferInfo) {
		this.transferInfo = transferInfo == null ? null : transferInfo.trim();
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public Integer getDelayDay() {
		return delayDay;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setDelayDay(Integer delayDay) {
		this.delayDay = delayDay;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public Integer getDelayValidDay() {
		return delayValidDay;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setDelayValidDay(Integer delayValidDay) {
		this.delayValidDay = delayValidDay;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public String getPrdParentName() {
		return prdParentName;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setPrdParentName(String prdParentName) {
		this.prdParentName = prdParentName == null ? null : prdParentName.trim();
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public String getOrganizationCode() {
		return organizationCode;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setOrganizationCode(String organizationCode) {
		this.organizationCode = organizationCode == null ? null : organizationCode.trim();
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public String getIsCouponLessGoods() {
		return isCouponLessGoods;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setIsCouponLessGoods(String isCouponLessGoods) {
		this.isCouponLessGoods = isCouponLessGoods == null ? null : isCouponLessGoods.trim();
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public Integer getGoodsCondition() {
		return goodsCondition;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setGoodsCondition(Integer goodsCondition) {
		this.goodsCondition = goodsCondition;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public Byte getChargeBack() {
		return chargeBack;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setChargeBack(Byte chargeBack) {
		this.chargeBack = chargeBack;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public Boolean getProlongValidDate() {
		return prolongValidDate;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setProlongValidDate(Boolean prolongValidDate) {
		this.prolongValidDate = prolongValidDate;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public Integer getProlongValidDateDay() {
		return prolongValidDateDay;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setProlongValidDateDay(Integer prolongValidDateDay) {
		this.prolongValidDateDay = prolongValidDateDay;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public String getCouponBackgroundUrl() {
		return couponBackgroundUrl;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setCouponBackgroundUrl(String couponBackgroundUrl) {
		this.couponBackgroundUrl = couponBackgroundUrl == null ? null : couponBackgroundUrl.trim();
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public Boolean getCouponBackgroundType() {
		return couponBackgroundType;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setCouponBackgroundType(Boolean couponBackgroundType) {
		this.couponBackgroundType = couponBackgroundType;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public Integer getApplianceOrgType() {
		return applianceOrgType;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setApplianceOrgType(Integer applianceOrgType) {
		this.applianceOrgType = applianceOrgType;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public String getApplianceOrgCodes() {
		return applianceOrgCodes;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setApplianceOrgCodes(String applianceOrgCodes) {
		this.applianceOrgCodes = applianceOrgCodes == null ? null : applianceOrgCodes.trim();
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public String getWmCouponDefinitionCode() {
		return wmCouponDefinitionCode;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setWmCouponDefinitionCode(String wmCouponDefinitionCode) {
		this.wmCouponDefinitionCode = wmCouponDefinitionCode == null ? null : wmCouponDefinitionCode.trim();
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public Boolean getLinkType() {
		return linkType;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setLinkType(Boolean linkType) {
		this.linkType = linkType;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public String getButtonName() {
		return buttonName;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setButtonName(String buttonName) {
		this.buttonName = buttonName == null ? null : buttonName.trim();
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public String getButtonNameCustom() {
		return buttonNameCustom;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setButtonNameCustom(String buttonNameCustom) {
		this.buttonNameCustom = buttonNameCustom == null ? null : buttonNameCustom.trim();
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public Integer getButtonShowType() {
		return buttonShowType;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setButtonShowType(Integer buttonShowType) {
		this.buttonShowType = buttonShowType;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public Date getCustomizeStartTime() {
		return customizeStartTime;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setCustomizeStartTime(Date customizeStartTime) {
		this.customizeStartTime = customizeStartTime;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public Date getCustomizeEndTime() {
		return customizeEndTime;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setCustomizeEndTime(Date customizeEndTime) {
		this.customizeEndTime = customizeEndTime;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public Integer getBeforeCouponExpireDay() {
		return beforeCouponExpireDay;
	}

	/**
	 * 只读. 
	 * @mbg.generated
	 */
	public void setBeforeCouponExpireDay(Integer beforeCouponExpireDay) {
		this.beforeCouponExpireDay = beforeCouponExpireDay;
	}

		/**
   * 运营组织名称
   */
  @TableField(exist = false)
  private String organizationName;
  
  @ApiModelProperty(value = "发券二级批次号（系统）",name = "发券二级批次号（系统）", required = true,example = "")
  private Long batchSendCodeDetail;

	public Long getBatchSendCodeDetail() {
        return batchSendCodeDetail;
    }

    public void setBatchSendCodeDetail(Long batchSendCodeDetail) {
        this.batchSendCodeDetail = batchSendCodeDetail;
    }
    public String getOrganizationName() {
        return organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

}