package com.bizvane.couponfacade.models.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.ToString;

import java.io.Serializable;
import java.util.List;

@ToString
public class SendCouponSimpleRequestVO implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "会员code", name = "memberCode", required = false, example = "")
    private String memberCode;

    @ApiModelProperty(value = "券定义id", name = "couponDefinitionId", required = false, example = "")
    private Long couponDefinitionId;

    @ApiModelProperty(value = "发送类型", name = "sendType", required = false, example = "")
    private String sendType;

    @ApiModelProperty(value = "业务id", name = "sendBussienId", required = false, example = "")
    private Long sendBussienId;

    @ApiModelProperty(value = "任务名称", name = "businessName", required = false, example = "")
    private String businessName;

    @ApiModelProperty(value = "品牌id", name = "brandId", required = false, example = "")
    private Long brandId;

    @ApiModelProperty(value = "企业id", name = "companyId", required = false, example = "")
    private Long companyId;

    @ApiModelProperty(value = "品牌号", name = "brandCode", required = false, example = "")
    private String brandCode;
    
    @ApiModelProperty(value = "涨红包taskId", name = "taskId", required = false, example = "")
    private String taskId;

    @ApiModelProperty(value = "天猫昵称", name = "tmallNick", required = false, example = "")
    private String tmallNick;

    @ApiModelProperty(value = "发卷任务id(生成异业券id)", name = "manualId", required = false, example = "")
    private Long manualId;

    @ApiModelProperty(value = "导购id", name = "sendGuideId", required = false, example = "")
    private Long sendGuideId;
    @ApiModelProperty(value = "导购id集合", name = "sendGuideIdList", required = false, example = "")
    private List<Long> sendGuideIdList;

    @ApiModelProperty(value = "发券数量", name = "sendCouponQuantity", required = false, example = "")
    private Integer sendCouponQuantity = 1;

    @ApiModelProperty(value = "礼包id", name = "mktGiftBagId", required = false, example = "")
    private Long mktGiftBagId;

    @ApiModelProperty(value = "礼包名称", name = "mktGiftBagName", required = false, example = "")
    private String mktGiftBagName;

    @ApiModelProperty(value = "是否为礼包中最后一张券(0否1是)", name = "isGiftBagLastCoupon", required = false, example = "")
    private Byte isGiftBagLastCoupon = 0;


    public String getTaskId() {
		return taskId;
	}

	public void setTaskId(String taskId) {
		this.taskId = taskId;
	}

	public String getBusinessName() {
        return businessName;
    }

    public void setBusinessName(String businessName) {
        this.businessName = businessName;
    }

    public Long getBrandId() {
        return brandId;
    }

    public void setBrandId(Long brandId) {
        this.brandId = brandId;
    }

    public Long getCompanyId() {
        return companyId;
    }

    public void setCompanyId(Long companyId) {
        this.companyId = companyId;
    }

    public String getMemberCode() {
        return memberCode;
    }

    public void setMemberCode(String memberCode) {
        this.memberCode = memberCode;
    }

    public Long getCouponDefinitionId() {
        return couponDefinitionId;
    }

    public void setCouponDefinitionId(Long couponDefinitionId) {
        this.couponDefinitionId = couponDefinitionId;
    }

    public String getSendType() {
        return sendType;
    }

    public void setSendType(String sendType) {
        this.sendType = sendType;
    }

    public Long getSendBussienId() {
        return sendBussienId;
    }

    public void setSendBussienId(Long sendBussienId) {
        this.sendBussienId = sendBussienId;
    }

    public String getBrandCode() {
        return brandCode;
    }

    public void setBrandCode(String brandCode) {
        this.brandCode = brandCode;
    }

    public String getTmallNick() {
        return tmallNick;
    }

    public void setTmallNick(String tmallNick) {
        this.tmallNick = tmallNick;
    }

    public Long getManualId() {
        return manualId;
    }

    public void setManualId(Long manualId) {
        this.manualId = manualId;
    }

    public Long getSendGuideId() {
        return sendGuideId;
    }

    public void setSendGuideId(Long sendGuideId) {
        this.sendGuideId = sendGuideId;
    }

    public List<Long> getSendGuideIdList() {
        return sendGuideIdList;
    }

    public void setSendGuideIdList(List<Long> sendGuideIdList) {
        this.sendGuideIdList = sendGuideIdList;
    }

    public Integer getSendCouponQuantity() {
        return sendCouponQuantity;
    }

    public void setSendCouponQuantity(Integer sendCouponQuantity) {
        this.sendCouponQuantity = sendCouponQuantity;
    }

    public Long getMktGiftBagId() {
        return mktGiftBagId;
    }

    public void setMktGiftBagId(Long mktGiftBagId) {
        this.mktGiftBagId = mktGiftBagId;
    }

    public String getMktGiftBagName() {
        return mktGiftBagName;
    }

    public void setMktGiftBagName(String mktGiftBagName) {
        this.mktGiftBagName = mktGiftBagName;
    }

    public Byte getIsGiftBagLastCoupon() {
        return isGiftBagLastCoupon;
    }

    public void setIsGiftBagLastCoupon(Byte isGiftBagLastCoupon) {
        this.isGiftBagLastCoupon = isGiftBagLastCoupon;
    }
}
