package com.bizvane.couponfacade.models.vo.standard;

import lombok.Data;

import java.math.BigDecimal;

/**
 * @author xz
 * @date 2020/3/5 9:43
 **/

@Data
public class StandardCouponUseRequestVo {
    /**
     * 企业id
     */
    private Long sysCompanyId;
    /**
     * 品牌code
     */
    private String brandCode;
    
    /**
     * 适用俱乐部，不传时视作在brandCode可用，多个俱乐部时，以逗号隔开传入
     *
     * 示例：TW-CLUB,VG-CLUB
     */
    private String applyBrandCode;
    /**
     * 券code
     */
    private String couponCode;
    /**
     * 线下核销门店Code
     */
    private String storeCode;
    /**
     * 	核销订单号
     */
    private String orderNo;
    /**
     * 核销订单金额
     */
    private Double orderAmount;

    /**
     * 成交金额（订单原价未使用优惠前订单价格）
     */
    private BigDecimal dealAmount;

    /**
     * 核销时间
     */
    private String useTime;

}
