package com.bizvane.couponfacade.interfaces;

import com.bizvane.couponfacade.es.CouponEntityInfoSearchPojo;
import com.bizvane.couponfacade.models.bo.CouponByCodeReq361BO;
import com.bizvane.couponfacade.models.bo.CouponEntityResponseBO;
import com.bizvane.couponfacade.models.bo.CouponLockReq361BO;
import com.bizvane.couponfacade.models.dto.CouponMergeCardRequestDto;
import com.bizvane.couponfacade.models.po.CouponEntityPO;
import com.bizvane.couponfacade.models.vo.CouponEntityVO;
import com.bizvane.couponfacade.models.vo.CouponSendMemberListRequestVO;
import com.bizvane.couponfacade.models.vo.CouponSendMemberListResponseVO;
import com.bizvane.couponfacade.models.vo.CouponStatusUpdateBatchRequestVO;
import com.bizvane.couponfacade.utils.PageFormUtil;
import com.bizvane.utils.responseinfo.ResponseData;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.Date;
import java.util.List;

/**
 * @author bizvane
 */
@FeignClient(value="${feign.client.coupon.name}",path="${feign.client.coupon.path}/couponEntityRpc")
@Api(value = "券实例接口",tags = {"券实例接口"})
public interface CouponEntityServiceFeign {

    /**
     * 只读
     * @param memberCode
     * @param sendBusinessId
     * @param date
     * @return
     */
    @ApiOperation(value = "查询会员是否有某个券", notes = "查询会员是否有某个券", tags = {"券实例接口"},httpMethod = "POST")
    @RequestMapping(value="/findCouponHave", method = RequestMethod.POST)
    public ResponseData<List<CouponEntityPO>> findCouponHave(@RequestParam(value = "memberCode",required = false)String memberCode,
                                                             @RequestParam(value = "sendBusinessId",required = false)Long sendBusinessId,
                                                             @RequestParam(value = "date",required = false)String date);

    /**
     * 只读
     * @param vo
     * @return
     */
    @ApiOperation(value = "优惠券查询", notes = "优惠券查询", tags = {"券实例接口"},httpMethod = "POST")
    @RequestMapping(value = "/rpcGetList", method = RequestMethod.POST)
    ResponseData<PageInfo<CouponEntityInfoSearchPojo>> rpcGetList(@RequestBody CouponEntityVO vo) ;


    /**
     * 只读
     * @param memberCode
     * @param sendType
     * @param sendBusinessId
     * @param date
     * @return
     */
    @ApiOperation(value = "查询会员是否有某个券", notes = "查询会员是否有某个券", tags = {"券实例接口"},httpMethod = "POST")
    @RequestMapping(value="/findCouponHaveType", method = RequestMethod.POST)
    public ResponseData<List<CouponEntityPO>> findCouponHaveType(@RequestParam(value = "memberCode",required = false)String memberCode,
    		                                                 @RequestParam(value = "sendType",required = false)String sendType,
                                                             @RequestParam(value = "sendBusinessId",required = false)Long sendBusinessId,
                                                             @RequestParam(value = "date",required = false)String date);

    /**
     * 只读
     * @param couponCode
     * @param couponStatus
     * @param ifSendAgain
     * @return
     */
    @ApiOperation(value = "单张发券收到线下处理结果", notes = "根据couponCode更新券状态", tags = {"券实例接口"},httpMethod = "POST")
    @RequestMapping(value="/updateCouponStatus", method = RequestMethod.POST)
    public ResponseData<Integer> updateCouponStatus(@RequestParam("couponCode")String couponCode,
                                                    @RequestParam("couponStatus")Byte couponStatus,
                                                    @RequestParam("ifSendAgain")Integer ifSendAgain);

    /**
     * 只读
     * @param vo
     * @return
     */
    @ApiOperation(value = "批量发券收到线下处理结果", notes = "根据couponCode批量更新券状态", tags = {"券实例接口"},httpMethod = "POST")
    @RequestMapping(value="/updateCouponStatusBatch", method = RequestMethod.POST)
    public ResponseData<Integer> updateCouponStatusBatch(@RequestBody CouponStatusUpdateBatchRequestVO vo);


    /**
     * 只读
     * @param requestVO
     * @return
     */
    @ApiOperation(value = "查询活动/任务发送的券的会员列表", notes = "查询活动/任务发送的券的会员列表", tags = {"券实例接口"},httpMethod = "POST")
    @RequestMapping(value="/findCouponSendMemberList", method = RequestMethod.POST)
    public ResponseData<PageInfo<CouponSendMemberListResponseVO>> findCouponSendMemberList(@RequestBody(required = false)CouponSendMemberListRequestVO requestVO);

    /**
     * 只读
     * @param requestVO
     * @return
     */
    @ApiOperation(value = "查询会员优惠券列表", notes = "查询会员优惠券列表", tags = {"券实例接口"},httpMethod = "POST")
    @RequestMapping(value="/bycardnoqueryCoupon", method = RequestMethod.POST)
    ResponseData<PageInfo<CouponEntityResponseBO>> bycardnoqueryCoupon(@RequestBody(required = false) CouponByCodeReq361BO requestVO);

    /**
     * 只读
     * @param requestVO
     * @return
     */
    @ApiOperation(value = "优惠券冻结", notes = "优惠券冻结", tags = {"券实例接口"},httpMethod = "POST")
    @RequestMapping(value="/lockCoupon", method = RequestMethod.POST)
    ResponseData lockCoupon(@RequestBody(required = false) CouponLockReq361BO requestVO);

    /**
     * 只读
     * @param requestVO
     * @return
     */
    @ApiOperation(value = "优惠券解冻", notes = "优惠券解冻", tags = {"券实例接口"},httpMethod = "POST")
    @RequestMapping(value="/unLockCoupon", method = RequestMethod.POST)
    ResponseData unLockCoupon(@RequestBody(required = false) CouponLockReq361BO requestVO);


    /**
     * 卷合卡操作
     * @param dto
     * @return
     */
    @RequestMapping(value = "couponMergeCard", method = RequestMethod.POST)
    ResponseData couponMergeCard(@RequestBody CouponMergeCardRequestDto dto);

    /**
     * 根据实体券号记录同步微盟会员领实体券记录
     * @param couponCode
     * @return
     */
    @RequestMapping(value = "addCouponEntityToWmErrorForRecode", method = RequestMethod.POST)
    ResponseData addCouponEntityToWmErrorForRecode(@RequestParam("couponCode") String couponCode);

}
