package com.bizvane.couponfacade.models.vo.standard;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author zcc
 * @date 2021/3/23 16:43
 **/
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class StandardCouponEntityAddVo extends StandardCouponCommonRequireVo implements Serializable {
    private static final long serialVersionUID = -2674831683587825722L;

    /**
     * 券定义code
     */
    private String couponDefinitionCode;

    /**
     * 券实例coupon_code
     */
    private String couponCode;

    /**
     * 券名称. coupon_name
     */
    private String couponName;

    /**
     * 面额. money
     */
    private BigDecimal money;

    /**
     * 折扣. discount
     */
    private BigDecimal discount;

    /**
     * 有效期开始时间. valid_date_start
     */
    private Date validDateStart;

    /**
     * 有效期结束时间. valid_date_end
     */
    private Date validDateEnd;

    /**
     * 券说明. info
     */
    private String info;



}
