package com.bizvane.connectorservice.entity.icrm;

import io.swagger.annotations.ApiModelProperty;
import lombok.ToString;

import java.io.Serializable;
import java.math.BigDecimal;
/**
 * @author admin
 */
@ToString
public class RechargeCardRecordResponseVO implements Serializable {

    @ApiModelProperty(
            value = "主键id",
            name = "prepaid_card_record_id",
            required = true,
            example = ""
    )
    private String prepaid_card_record_id;


    @ApiModelProperty(
            value = "储值卡id",
            name = "pid",
            required = true,
            example = ""
    )
    private String pid;

    @ApiModelProperty(
            value = "储值卡号",
            name = "pcode",
            required = true,
            example = ""
    )
    private String pcode;

    @ApiModelProperty(
            value = "变动前金额",
            name = "money_before",
            required = true,
            example = ""
    )
    private BigDecimal money_before;

    @ApiModelProperty(
            value = "变动金额",
            name = "money_change",
            required = true,
            example = ""
    )
    private BigDecimal money_change;

    @ApiModelProperty(
            value = "变动后金额",
            name = "money_after",
            required = true,
            example = ""
    )
    private BigDecimal money_after;

    @ApiModelProperty(
            value = "关联单号",
            name = "record_code",
            required = false,
            example = ""
    )
    private String record_code;

    @ApiModelProperty(
            value = "变动类型：销售开卡 充值 消费 消费退 过期调整 换卡转存 退款 余额调整",
            name = "change_type",
            required = true,
            example = ""
    )

    private  String change_type;

    @ApiModelProperty(
            value = "变动时间",
            name = "is_add_time",
            required = true,
            example = ""
    )
    private String is_add_time;

    @ApiModelProperty(
            value = "操作渠道",
            name = "org_code",
            required = false,
            example = ""
    )
    private String org_code;

    @ApiModelProperty(
            value = "操作店铺",
            name = "shop_code",
            required = false,
            example = ""
    )
    private String shop_code;

    @ApiModelProperty(
            value = "备注",
            name = "remark",
            required = false,
            example = ""
    )
    private String remark;

    @ApiModelProperty(
            value = "变动时间",
            name = "lastchanged",
            required = true,
            example = ""
    )
    private String lastchanged;

    @ApiModelProperty(
            value = "支付金额",
            name = "pay_money",
            required = true,
            example = ""
    )
    private BigDecimal pay_money;

    @ApiModelProperty(
            value = "回馈金额金额",
            name = "feedback_money",
            required = false,
            example = ""
    )
    private BigDecimal feedback_money;
    @ApiModelProperty(
            value = "操作来源",
            name = "source",
            required = true,
            example = ""
    )
    private String source;


    @ApiModelProperty(
            value = "积分增减（0-增加，1-减少）",
            name = "integral_type",
            required = true,
            example = ""
    )
    private Integer integral_type;

    @ApiModelProperty(
            value = "金额增减（0-增加，1-减少）",
            name = "money_type",
            required = true,
            example = ""
    )
    private Integer money_type;

    public String getPrepaid_card_record_id() {
        return prepaid_card_record_id;
    }

    public void setPrepaid_card_record_id(String prepaid_card_record_id) {
        this.prepaid_card_record_id = prepaid_card_record_id;
    }

    public String getPid() {
        return pid;
    }

    public void setPid(String pid) {
        this.pid = pid;
    }

    public String getPcode() {
        return pcode;
    }

    public void setPcode(String pcode) {
        this.pcode = pcode;
    }

    public BigDecimal getMoney_before() {
        return money_before;
    }

    public void setMoney_before(BigDecimal money_before) {
        this.money_before = money_before;
    }

    public BigDecimal getMoney_change() {
        return money_change;
    }

    public void setMoney_change(BigDecimal money_change) {
        this.money_change = money_change;
    }

    public BigDecimal getMoney_after() {
        return money_after;
    }

    public void setMoney_after(BigDecimal money_after) {
        this.money_after = money_after;
    }

    public String getRecord_code() {
        return record_code;
    }

    public void setRecord_code(String record_code) {
        this.record_code = record_code;
    }

    public String getChange_type() {
        return change_type;
    }

    public void setChange_type(String change_type) {
        this.change_type = change_type;
    }

    public String getIs_add_time() {
        return is_add_time;
    }

    public void setIs_add_time(String is_add_time) {
        this.is_add_time = is_add_time;
    }

    public String getOrg_code() {
        return org_code;
    }

    public void setOrg_code(String org_code) {
        this.org_code = org_code;
    }

    public String getShop_code() {
        return shop_code;
    }

    public void setShop_code(String shop_code) {
        this.shop_code = shop_code;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getLastchanged() {
        return lastchanged;
    }

    public void setLastchanged(String lastchanged) {
        this.lastchanged = lastchanged;
    }

    public BigDecimal getPay_money() {
        return pay_money;
    }

    public void setPay_money(BigDecimal pay_money) {
        this.pay_money = pay_money;
    }

    public BigDecimal getFeedback_money() {
        return feedback_money;
    }

    public void setFeedback_money(BigDecimal feedback_money) {
        this.feedback_money = feedback_money;
    }

    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public Integer getIntegral_type() {
        return integral_type;
    }

    public void setIntegral_type(Integer integral_type) {
        this.integral_type = integral_type;
    }

    public Integer getMoney_type() {
        return money_type;
    }

    public void setMoney_type(Integer money_type) {
        this.money_type = money_type;
    }
}
