/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.connectorservice.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtil {
    private static Pattern IS_DIGITAL = Pattern.compile("\\s*\\d+\\s*$");
    private static Pattern IS_NUMERIC = Pattern.compile("\\s*-?[0-9]+(.[0-9]+)?\\s*$");
    private static Pattern IS_FULL_DATE = Pattern.compile("^(\\s*\\d{2}|\\d{4})(\\-|/)\\d{1,2}(\\-|/)\\d{1,2}\\s+\\d{1,2}(\\:|\\\uff1a)\\d{1,2}(\\:|\\\uff1a)\\d{1,2}\\s*$");
    private static Pattern IS_DATE = Pattern.compile("^(\\s*\\d{2}|\\d{4})(\\-|/)\\d{1,2}(\\-|/)\\d{1,2}\\s*$");

    public static String valueOf(Object o) {
        if (o == null) {
            return "";
        }
        String ov = o.toString().trim();
        return "null".equalsIgnoreCase(ov) ? "" : ov;
    }

    public static boolean isNull(Object o) {
        if (o == null) {
            return true;
        }
        String to = StringUtil.valueOf(o);
        return to.trim().isEmpty() || "".equals(to.trim());
    }

    public static boolean isNotNull(Object o) {
        return !StringUtil.isNull(o);
    }

    public static boolean isDigital(String o) {
        Matcher isNum = IS_DIGITAL.matcher(o);
        return isNum.matches();
    }

    public static boolean isNumeric(String str) {
        Matcher isNum = IS_NUMERIC.matcher(str);
        return isNum.matches();
    }

    public static String valueOf(Object o, String defaultvalue) {
        String s = null;
        s = StringUtil.isNull(o) ? defaultvalue : StringUtil.valueOf(o);
        return s;
    }

    public static boolean isFullDate(Object o) {
        if (StringUtil.isNull(o)) {
            return false;
        }
        String str = StringUtil.valueOf(o).trim();
        Matcher isNum = IS_FULL_DATE.matcher(str);
        return isNum.matches();
    }

    public static boolean isDate(Object o) {
        if (StringUtil.isNull(o)) {
            return false;
        }
        String str = StringUtil.valueOf(o).trim();
        Matcher isNum = IS_DATE.matcher(str);
        return isNum.matches();
    }
}

