package com.bizvane.connectorservice.interfaces.rpc;

import com.bizvane.connectorservice.entity.Result;
import com.bizvane.connectorservice.entity.common.CouponBatchBindRequestVO;
import com.bizvane.connectorservice.entity.common.CouponBatchRequestVO;
import com.bizvane.connectorservice.entity.common.CouponBindRequestVO;
import com.bizvane.connectorservice.entity.common.CouponRequestVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@FeignClient(value="${feign.client.connectorcoupon.name:connectorcoupon}", path="${feign.client.connectorcoupon.path:connectorcoupon.api}/rest")
public abstract interface ConnectorCouponServiceFeign
{
  @RequestMapping(value={"batchcoupon"}, method={org.springframework.web.bind.annotation.RequestMethod.POST})
  public abstract Result batchcoupon(@RequestBody CouponBatchRequestVO paramCouponBatchRequestVO);
  
  @RequestMapping(value={"singlecoupon"}, method={org.springframework.web.bind.annotation.RequestMethod.POST})
  public abstract Result singlecoupon(@RequestBody CouponRequestVO paramCouponRequestVO);
  
  @RequestMapping(value={"batchcouponbind"}, method={org.springframework.web.bind.annotation.RequestMethod.POST})
  public abstract Result batchCouponBind(@RequestBody CouponBatchBindRequestVO paramCouponBatchBindRequestVO);
  
  @RequestMapping(value={"singlecouponbind"}, method={org.springframework.web.bind.annotation.RequestMethod.POST})
  public abstract Result singleCouponBind(@RequestBody CouponBindRequestVO paramCouponBindRequestVO);
}
