package com.bizvane.connectorservice.entity.common;

import com.bizvane.connectorservice.entity.base.BaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author liuying
 * @date 2018/8/9
 * @description
 */
@Data
public class IntegralAdjustRequestVO  extends BaseModel {


    /**
     * 订单编号
     */
    private String orderBillNo;

    /**
     * 线下卡号   361必填
     */
    private String offlineCardNo;

    /**
     * 调整积分数量  361必填
     */
    private Integer changeIntegral;

    /**
     * 调整类型
     */
    private Integer changeType;

    /**
     * 业务类型(统一定义)
     */
    private String businessType;

    /**
     * 调整详情
     */
    private String detail;

    /**
     * 所属门店UR
     */
    private String  storeId;
    /**
     * 积分数额UR
     */
    private Double pointsAmount;

    /**
     * 来源 UR  361必填为999
     */
    private String  source;

    /**
     * 关联积分流水id
     */
    private String relationPointsIdUnique;

    /**
     * 积分流水id防重 UR
     */
    private String pointsIdUnique;

    /**
     * 以下为361 加的字段
     */
    /**
     * 关联单据
     */
    private String relationCode;

    /**
     *	新增时间
     * @return
     */
    private String addTime;

    /**
     * 顾客代码
     */
    private String erpId;

    /**
     * 渠道
     */
    private String orgCode;

    /**
     * 店铺code
     */
    private String shopCode;

    /**
     * 兑换的优惠券号
     */
    private String  couponCode;

    /**
     * 产生类型
     */
    private String createType;


    /**
     * 会员淘宝Nick
     * */
    private String taobaoNick;

    /**
     * linkflow
     * 积分唯一流水号
     * */
    private String serialNumber;

    @ApiModelProperty(name = "changeDetails", value = "开启负积分")
    private Boolean enableNegativeIntegral = Boolean.FALSE;

    @ApiModelProperty(name = "changeDetails", value = "开启线下积分幂等")
    private Boolean enableIdempotentIntegral = Boolean.FALSE;

    @ApiModelProperty(name = "changeDetails", value = "开启补偿积分")
    private Boolean enableCompensateIntegral = Boolean.FALSE;

    public String getSerialNumber() {
        return serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public String getTaobaoNick() {
        return taobaoNick;
    }

    public void setTaobaoNick(String taobaoNick) {
        this.taobaoNick = taobaoNick;
    }

    public String getOrderBillNo() {
        return orderBillNo;
    }

    public void setOrderBillNo(String orderBillNo) {
        this.orderBillNo = orderBillNo;
    }

    public String getOfflineCardNo() {
        return offlineCardNo;
    }

    public void setOfflineCardNo(String offlineCardNo) {
        this.offlineCardNo = offlineCardNo;
    }

    public Integer getChangeIntegral() {
        return changeIntegral;
    }

    public void setChangeIntegral(Integer changeIntegral) {
        this.changeIntegral = changeIntegral;
    }

    public Integer getChangeType() {
        return changeType;
    }

    public void setChangeType(Integer changeType) {
        this.changeType = changeType;
    }

    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    public String getDetail() {
        return detail;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public String getStoreId() {
        return storeId;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public Double getPointsAmount() {
        return pointsAmount;
    }

    public void setPointsAmount(Double pointsAmount) {
        this.pointsAmount = pointsAmount;
    }

    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getPointsIdUnique() {
        return pointsIdUnique;
    }

    public void setPointsIdUnique(String pointsIdUnique) {
        this.pointsIdUnique = pointsIdUnique;
    }


    public String getRelationCode() {
        return relationCode;
    }

    public void setRelationCode(String relationCode) {
        this.relationCode = relationCode;
    }

    public String getAddTime() {
        return addTime;
    }

    public void setAddTime(String addTime) {
        this.addTime = addTime;
    }

    public String getErpId() {
        return erpId;
    }

    public void setErpId(String erpId) {
        this.erpId = erpId;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getShopCode() {
        return shopCode;
    }

    public void setShopCode(String shopCode) {
        this.shopCode = shopCode;
    }

    public String getCouponCode() {
        return couponCode;
    }

    public void setCouponCode(String couponCode) {
        this.couponCode = couponCode;
    }

    public String getCreateType() {
        return createType;
    }

    public void setCreateType(String createType) {
        this.createType = createType;
    }
}
