package com.bizvane.connectorservice.interfaces.weimeng;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.connectorservice.entity.out.wm.UpdateMemberInfoRequestVO;

/**
 * @author ljc
 * @date 2020/5/13 10:12
 **/

public interface WeiMengService {

    /**
     * 根据品牌id和code得到相关token
     * @param brandId
     * @param code
     */
    void getTokenBycode(Long brandId, String code);

    /**
     * 根据refreshToken刷新accessToken
     */
    void refreshToken();

    /**
     * 判断是否有微盟商城渠道
     * @param allChannelIds
     * @return
     */
    Boolean judgeAllChannelIds(String allChannelIds);

    /**
     * 获取会员wid
     * @param
     * @return
     */
    Long getMemberWid(Long brandId, JSONObject jsonRequest);

    /**
     * 调用微盟修改会员信息
     * @param brandId
     * @param requestVO
     */
    void updateMemberInfo(Long brandId, UpdateMemberInfoRequestVO requestVO);

}
